/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.suite;

import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.util.AbiUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SuiteTestFilter {
    private final Integer mShardIndex;
    private final String mAbi;
    private final String mName;
    private final String mTest;
    private static final Pattern PARAMETERIZED_TEST_REGEX = Pattern.compile("(.*)?\\[(.*)\\]$");

    public static SuiteTestFilter createFrom(String filter) {
        if (filter.isEmpty()) {
            throw new HarnessRuntimeException("Filter was empty", InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
        }
        String[] parts = filter.split(" +");
        Integer shardIndex = null;
        String abi = null;
        String name = null;
        String test = null;
        if (parts.length == 1) {
            name = parts[0];
        } else {
            int index = 0;
            if (parts[index].startsWith("shard_")) {
                shardIndex = Integer.parseInt(parts[index].substring("shard_".length()));
                ++index;
            } else {
                try {
                    shardIndex = Integer.parseInt(parts[index]);
                    ++index;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (AbiUtils.isAbiSupportedByCompatibility(parts[index])) {
                abi = parts[index];
                ++index;
            }
            name = parts[index];
            if ((parts = filter.split(" +", ++index + 1)).length > index) {
                test = parts[index];
            }
        }
        return new SuiteTestFilter(shardIndex, abi, name, test);
    }

    public SuiteTestFilter(String abi, String name, String test) {
        this(null, abi, name, test);
    }

    public SuiteTestFilter(Integer shardIndex, String abi, String name, String test) {
        this.mShardIndex = shardIndex;
        this.mAbi = abi;
        this.mName = name;
        this.mTest = test;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.mShardIndex != null) {
            sb.append(this.mShardIndex.toString());
            sb.append(" ");
        }
        if (this.mAbi != null) {
            sb.append(this.mAbi.trim());
            sb.append(" ");
        }
        if (this.mName != null) {
            sb.append(this.mName.trim());
        }
        if (this.mTest != null) {
            sb.append(" ");
            sb.append(this.mTest.trim());
        }
        return sb.toString();
    }

    public Integer getShardIndex() {
        return this.mShardIndex;
    }

    public String getAbi() {
        return this.mAbi;
    }

    public String getName() {
        return this.mName;
    }

    public String getModuleId() {
        StringBuilder sb = new StringBuilder();
        if (this.mAbi != null) {
            sb.append(this.mAbi.trim());
            sb.append(" ");
        }
        if (this.mName != null) {
            sb.append(this.mName.trim());
        }
        return sb.toString();
    }

    public String getBaseName() {
        Matcher m = PARAMETERIZED_TEST_REGEX.matcher(this.mName);
        if (m.find()) {
            return m.group(1);
        }
        return this.mName;
    }

    public String getParameterName() {
        Matcher m = PARAMETERIZED_TEST_REGEX.matcher(this.mName);
        if (m.find()) {
            return m.group(2);
        }
        return null;
    }

    public String getTest() {
        return this.mTest;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mAbi == null ? 0 : this.mAbi.hashCode());
        result = 31 * result + (this.mName == null ? 0 : this.mName.hashCode());
        result = 31 * result + (this.mShardIndex == null ? 0 : this.mShardIndex.hashCode());
        result = 31 * result + (this.mTest == null ? 0 : this.mTest.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SuiteTestFilter other = (SuiteTestFilter)obj;
        if (this.mAbi == null ? other.mAbi != null : !this.mAbi.equals(other.mAbi)) {
            return false;
        }
        if (this.mName == null ? other.mName != null : !this.mName.equals(other.mName)) {
            return false;
        }
        if (this.mShardIndex == null ? other.mShardIndex != null : !this.mShardIndex.equals(other.mShardIndex)) {
            return false;
        }
        return !(this.mTest == null ? other.mTest != null : !this.mTest.equals(other.mTest));
    }
}

