/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.suite;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;

public class TestFailureListener
implements ITestInvocationListener {
    private List<ITestDevice> mListDevice;
    private ITestLogger mLogger;
    private boolean mBugReportOnFailure;
    private boolean mRebootOnFailure;
    private boolean mModuleBugReportOnFailure = true;

    public TestFailureListener(List<ITestDevice> devices, boolean bugReportOnFailure, boolean rebootOnFailure) {
        this.mListDevice = devices;
        this.mBugReportOnFailure = bugReportOnFailure;
        this.mRebootOnFailure = rebootOnFailure;
    }

    @Override
    public void testFailed(TestDescription test, String trace) {
        LogUtil.CLog.i("FailureListener.testFailed %s %b", test.toString(), this.mBugReportOnFailure);
        for (ITestDevice device : this.mListDevice) {
            this.captureFailure(device, test);
        }
    }

    private void captureFailure(ITestDevice device, TestDescription test) {
        CloseableTraceScope ignored;
        String serial = device.getSerialNumber();
        if (this.mBugReportOnFailure && this.mModuleBugReportOnFailure) {
            ignored = new CloseableTraceScope("bugreport_on_failure");
            try {
                if (!device.logBugreport(String.format("%s-%s-bugreport", test.toString(), serial), this.mLogger)) {
                    LogUtil.CLog.e("Failed to capture bugreport for %s failure on %s.", test, serial);
                }
            }
            finally {
                ignored.close();
            }
        }
        if (this.mRebootOnFailure) {
            try {
                ignored = new CloseableTraceScope("reboot_on_failure");
                try {
                    if ("user".equals(device.getProperty("ro.build.type"))) {
                        LogUtil.CLog.e("Reboot-on-failure should only be used during development, this is a\" user\" build device");
                    } else {
                        device.reboot();
                    }
                }
                finally {
                    ignored.close();
                }
            }
            catch (DeviceNotAvailableException e) {
                LogUtil.CLog.e(e);
                LogUtil.CLog.e("Device %s became unavailable while rebooting", serial);
            }
        }
    }

    public void join() {
        this.mModuleBugReportOnFailure = true;
    }

    public void testLogForward(String dataName, LogDataType dataType, InputStreamSource dataStream) {
        this.mLogger.testLog(dataName, dataType, dataStream);
    }

    @Override
    public void testLog(String dataName, LogDataType dataType, InputStreamSource dataStream) {
    }

    @VisibleForTesting
    IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    public void applyModuleConfiguration(boolean bugreportOnFailure) {
        this.mModuleBugReportOnFailure = bugreportOnFailure;
    }

    public void setLogger(ITestLogger logger) {
        this.mLogger = logger;
    }
}

