/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.suite;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.ConfigurationDescriptor;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.suite.BaseTestSuite;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.ZipUtil2;
import com.android.tradefed.util.testmapping.TestInfo;
import com.android.tradefed.util.testmapping.TestMapping;
import com.android.tradefed.util.testmapping.TestOption;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class TestMappingSuiteRunner
extends BaseTestSuite {
    @Option(name="test-mapping-test-group", description="Group of tests to run, e.g., presubmit, postsubmit. The suite runner shall load the tests defined in all TEST_MAPPING files in the source code, through build artifact test_mappings.zip.")
    private String mTestGroup = null;
    @Option(name="test-mapping-keyword", description="Keyword to be matched to the `keywords` setting of a test configured in a TEST_MAPPING file. The test will only run if it has all the keywords specified in the option. If option test-mapping-test-group is not set, test-mapping-keyword option is ignored as the tests to run are not loaded directly from TEST_MAPPING files but is supplied via the --include-filter arg.")
    private Set<String> mKeywords = new LinkedHashSet<String>();
    @Option(name="test-mapping-ignore-keyword", description="Keyword to be ignored to the `keywords` setting of a test configured in a TEST_MAPPING file. If a test entry has specified keywords in their `keywords` attribute, the given keywords will be ignored. This allows a test mapping suite to support test entries requiring a keyword without running them on a new test suite.")
    private Set<String> mIgnoreKeywords = new LinkedHashSet<String>();
    @Option(name="force-test-mapping-module", description="Run the specified tests only. The tests loaded from all TEST_MAPPING files in the source code will be filtered again to force run the specified tests.")
    private Set<String> mTestModulesForced = new HashSet<String>();
    @Option(name="test-mapping-path", description="Run tests according to the test mapping path.")
    private List<String> mTestMappingPaths = new ArrayList<String>();
    @Option(name="remote-test-timeout", description="The timeout that will be applied to each remote test object of the run.")
    private Duration mRemoteTestTimeOut = null;
    @Option(name="use-test-mapping-path", description="Whether or not to run tests based on the given test mapping path.")
    private boolean mUseTestMappingPath = false;
    @Option(name="ignore-test-mapping-imports", description="Whether or not to ignore test mapping import paths.")
    private boolean mIgnoreTestMappingImports = true;
    @Option(name="test-mapping-allowed-tests-list", description="A list of artifacts that contains allowed tests. Only tests in the lists will be run. If no list is specified, the tests will not be filtered by allowed tests.")
    private Set<String> mAllowedTestLists = new HashSet<String>();
    @Option(name="additional-test-mapping-zip", description="A list of additional test_mappings.zip that contains TEST_MAPPING files. The runner will collect tests based on them. If none is specified, only the tests on the triggering device build will be run.")
    private List<String> mAdditionalTestMappingZips = new ArrayList<String>();
    @Option(name="test-mapping-matched-pattern-paths", description="A list of modified paths that matches with a certain file_pattern in the TEST_MAPPING file. This is used only for Work Node, and handled by provider service.")
    private Set<String> mMatchedPatternPaths = new HashSet<String>();
    @Option(name="allow-empty-tests", description="Whether or not to raise an exception if no tests to be ran. This is to provide a feasibility for test mapping sampling.")
    private boolean mAllowEmptyTests = false;
    @Option(name="force-full-run", description="Whether or not to run full tests. It is to provide a feasibility for tests on kernel branches. The option should only be used for kernel tests.")
    private boolean mForceFullRun = false;
    @Option(name="report-import-paths", description="Whether or not to report import paths into AnTS.")
    private boolean mReportImportPaths = false;
    private static final String TEST_MAPPING_INCLUDE_FILTER = "include-filter";
    private static final String TEST_MAPPING_EXCLUDE_FILTER = "exclude-filter";
    private IBuildInfo mBuildInfo;

    public TestMappingSuiteRunner() {
        this.setSkipjarLoading(true);
    }

    public Set<TestInfo> loadTestInfos() {
        Set<String> includeFilter = this.getIncludeFilter();
        LinkedHashSet<String> testNames = new LinkedHashSet<String>();
        Set<TestInfo> testInfosToRun = new LinkedHashSet<TestInfo>();
        this.mBuildInfo = this.getBuildInfo();
        if (this.mTestGroup == null && includeFilter.isEmpty()) {
            throw new HarnessRuntimeException("At least one of the options, --test-mapping-test-group or --include-filter, should be set.", InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
        }
        if (this.mTestGroup == null && !this.mKeywords.isEmpty()) {
            throw new HarnessRuntimeException("Must specify --test-mapping-test-group when applying --test-mapping-keyword.", InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
        }
        if (!this.mIgnoreKeywords.isEmpty() && !this.mKeywords.isEmpty()) {
            for (String keyword : this.mKeywords) {
                if (!this.mIgnoreKeywords.contains(keyword)) continue;
                throw new HarnessRuntimeException("Keyword cannot be in both required and ignored.", InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
            }
        }
        if (this.mTestGroup == null && !this.mTestModulesForced.isEmpty()) {
            throw new HarnessRuntimeException("Must specify --test-mapping-test-group when applying --force-test-mapping-module.", InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
        }
        if (this.mTestGroup != null && !includeFilter.isEmpty()) {
            throw new HarnessRuntimeException("If options --test-mapping-test-group is set, option --include-filter should not be set.", InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
        }
        if (!includeFilter.isEmpty() && !this.mTestMappingPaths.isEmpty()) {
            throw new HarnessRuntimeException("If option --include-filter is set, option --test-mapping-path should not be set.", InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
        }
        if (this.mReportImportPaths && !this.mIgnoreTestMappingImports) {
            LogUtil.CLog.i("Option \"no-ignore-test-mapping-imports\" and \"report-import-paths\" are enabled, TestMapping will report tests with sources and import paths to AnTS");
        }
        if (this.mTestGroup != null) {
            if (this.mForceFullRun) {
                LogUtil.CLog.d("--force-full-run is specified, all tests in test group %s will be ran.", this.mTestGroup);
                this.mTestMappingPaths.clear();
            }
            TestMapping testMapping = new TestMapping(this.mTestMappingPaths, this.mIgnoreTestMappingImports);
            testInfosToRun = testMapping.getTests(this.mBuildInfo, this.mTestGroup, this.getPrioritizeHostConfig(), this.mKeywords, this.mIgnoreKeywords, this.mAdditionalTestMappingZips, this.mMatchedPatternPaths);
            if (!this.mTestModulesForced.isEmpty()) {
                LogUtil.CLog.i("Filtering tests for the given names: %s", this.mTestModulesForced);
                testInfosToRun = testInfosToRun.stream().filter(testInfo -> this.mTestModulesForced.contains(testInfo.getName())).collect(Collectors.toSet());
            }
            if (!this.mAllowedTestLists.isEmpty()) {
                LogUtil.CLog.i("Filtering tests from allowed test lists: %s", this.mAllowedTestLists);
                testInfosToRun = this.filterByAllowedTestLists(this.mBuildInfo, testInfosToRun);
            }
            if (testInfosToRun.isEmpty() && !this.mAllowEmptyTests) {
                throw new HarnessRuntimeException(String.format("No test found for the given group: %s.", this.mTestGroup), InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
            }
            for (TestInfo testInfo2 : testInfosToRun) {
                testNames.add(testInfo2.getName());
            }
            this.setIncludeFilter(testNames);
            this.mTestGroup = null;
            this.mTestMappingPaths.clear();
            this.mUseTestMappingPath = false;
        }
        return testInfosToRun;
    }

    @Override
    public LinkedHashMap<String, IConfiguration> loadTests() {
        Set<TestInfo> testInfosToRun = this.loadTestInfos();
        LinkedHashMap<String, IConfiguration> testConfigs = super.loadTests();
        for (Map.Entry<String, IConfiguration> entry : testConfigs.entrySet()) {
            ArrayList<IRemoteTest> allTests = new ArrayList<IRemoteTest>();
            IConfiguration moduleConfig = entry.getValue();
            ConfigurationDescriptor configDescriptor = moduleConfig.getConfigurationDescription();
            IAbi abi = configDescriptor.getAbi();
            String moduleName = entry.getKey().replace(String.format("%s ", abi.getName()), "");
            Set<TestInfo> testInfos = this.getTestInfos(testInfosToRun, moduleName);
            allTests.addAll(this.createIndividualTests(testInfos, moduleConfig, abi));
            if (!allTests.isEmpty()) {
                moduleConfig.setTests(allTests);
                List<String> testSources = this.getTestSources(testInfos);
                configDescriptor.addMetadata("Test Sources", testSources);
            }
            if (this.mRemoteTestTimeOut == null) continue;
            configDescriptor.addMetadata("remote-test-timeout", this.mRemoteTestTimeOut.toString());
        }
        return testConfigs;
    }

    @VisibleForTesting
    String getTestGroup() {
        return this.mTestGroup;
    }

    public void clearTestGroup() {
        this.mTestGroup = null;
    }

    @VisibleForTesting
    List<String> getTestMappingPaths() {
        return this.mTestMappingPaths;
    }

    @VisibleForTesting
    boolean getUseTestMappingPath() {
        return this.mUseTestMappingPath;
    }

    @VisibleForTesting
    List<IRemoteTest> createIndividualTests(Set<TestInfo> testInfos, IConfiguration moduleConfig, IAbi abi) {
        ArrayList<IRemoteTest> tests = new ArrayList<IRemoteTest>();
        String configPath = moduleConfig.getName();
        Set<String> excludeFilterSet = this.getExcludeFilter();
        if (configPath == null) {
            throw new RuntimeException(String.format("Configuration path is null.", new Object[0]));
        }
        File configFile = new File(configPath);
        if (!configFile.exists()) {
            configFile = null;
        }
        if ((testInfos = this.dedupTestInfos(configFile, testInfos)).size() > 1) {
            moduleConfig.getConfigurationDescription().setNotIRemoteTestShardable(true);
        }
        for (TestInfo testInfo : testInfos) {
            super.cleanUpSuiteSetup();
            super.clearModuleArgs();
            super.setExcludeFilter(excludeFilterSet);
            if (configFile != null) {
                this.clearConfigPaths();
                this.addConfigPaths(configFile);
            }
            this.parseOptions(testInfo);
            LinkedHashMap<String, IConfiguration> config = super.loadTests();
            for (Map.Entry<String, IConfiguration> entry : config.entrySet()) {
                if (entry.getValue().getConfigurationDescription().getAbi() != null && !entry.getValue().getConfigurationDescription().getAbi().equals(abi)) continue;
                List<IRemoteTest> remoteTests = entry.getValue().getTests();
                this.addTestSourcesToConfig(moduleConfig, remoteTests, testInfo.getSources());
                if (this.mReportImportPaths && !this.mIgnoreTestMappingImports) {
                    this.addTestSourcesToConfig(moduleConfig, remoteTests, testInfo.getImportPaths());
                }
                tests.addAll(remoteTests);
            }
        }
        return tests;
    }

    private void addTestSourcesToConfig(IConfiguration config, List<IRemoteTest> tests, Set<String> sources) {
        for (IRemoteTest test : tests) {
            config.getConfigurationDescription().addMetadata(Integer.toString(test.hashCode()), new ArrayList<String>(sources));
        }
    }

    @VisibleForTesting
    List<String> getTestSources(Set<TestInfo> testInfos) {
        ArrayList<String> testSources = new ArrayList<String>();
        for (TestInfo testInfo : testInfos) {
            testSources.addAll(testInfo.getSources());
        }
        return testSources;
    }

    @VisibleForTesting
    void parseOptions(TestInfo testInfo) {
        HashSet<String> mappingIncludeFilters = new HashSet<String>();
        HashSet<String> mappingExcludeFilters = new HashSet<String>();
        HashSet<String> moduleArgs = new HashSet<String>();
        HashSet<String> testNames = new HashSet<String>();
        block8: for (TestOption option : testInfo.getOptions()) {
            switch (option.getName()) {
                case "include-filter": {
                    mappingIncludeFilters.add(String.format("%s %s", testInfo.getName(), option.getValue()));
                    continue block8;
                }
                case "exclude-filter": {
                    mappingExcludeFilters.add(String.format("%s %s", testInfo.getName(), option.getValue()));
                    continue block8;
                }
            }
            String moduleArg = String.format("%s:%s", testInfo.getName(), option.getName());
            if (option.getValue() != null && !option.getValue().isEmpty()) {
                moduleArg = String.format("%s:%s", moduleArg, option.getValue());
            }
            moduleArgs.add(moduleArg);
        }
        if (mappingIncludeFilters.isEmpty()) {
            testNames.add(testInfo.getName());
            this.setIncludeFilter(testNames);
        } else {
            this.setIncludeFilter(mappingIncludeFilters);
        }
        if (!mappingExcludeFilters.isEmpty()) {
            this.setExcludeFilter(mappingExcludeFilters);
        }
        this.addModuleArgs(moduleArgs);
    }

    @VisibleForTesting
    Set<TestInfo> dedupTestInfos(File config, Set<TestInfo> testInfos) {
        HashSet<String> nameOptions = new HashSet<String>();
        TreeSet<TestInfo> dedupTestInfos = new TreeSet<TestInfo>(new TestInfoComparator());
        LinkedHashSet<String> duplicateSources = new LinkedHashSet<String>();
        for (TestInfo testInfo : testInfos) {
            String nameOption = testInfo.getNameOption();
            if (!nameOptions.contains(nameOption)) {
                dedupTestInfos.add(testInfo);
                duplicateSources.addAll(testInfo.getSources());
                nameOptions.add(nameOption);
                continue;
            }
            this.aggregateTestInfo(testInfo, dedupTestInfos);
        }
        if (dedupTestInfos.size() > 1) {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.DUPLICATE_MAPPING_DIFFERENT_OPTIONS, String.format("%s:" + Joiner.on("+").join(duplicateSources), config));
        }
        return dedupTestInfos;
    }

    private static String createComparableNames(TestInfo a) {
        ArrayList<TestOption> copyOptions = new ArrayList<TestOption>(a.getOptions());
        copyOptions.removeIf(o -> o.isExclusive() || !o.isExclusive() && !o.isInclusive());
        return String.format("%s%s", a.getName(), ((Object)copyOptions).toString());
    }

    private void aggregateTestInfo(TestInfo testInfo, Set<TestInfo> dedupTestInfos) {
        for (TestInfo dedupTestInfo : dedupTestInfos) {
            if (!testInfo.getNameOption().equals(dedupTestInfo.getNameOption())) continue;
            dedupTestInfo.addSources(testInfo.getSources());
        }
    }

    @VisibleForTesting
    Set<TestInfo> getTestInfos(Set<TestInfo> testInfos, String moduleName) {
        return testInfos.stream().filter(testInfo -> moduleName.equals(testInfo.getName())).collect(Collectors.toSet());
    }

    @VisibleForTesting
    Set<TestInfo> filterByAllowedTestLists(IBuildInfo info, Set<TestInfo> testInfos) {
        HashSet<String> allowedTests = new HashSet<String>();
        for (String testList : this.mAllowedTestLists) {
            File testListZip = null;
            if (info == null) {
                String envBackfill = System.getenv(testList);
                if (envBackfill != null) {
                    testListZip = new File(envBackfill);
                }
            } else {
                testListZip = info.getFile(testList);
            }
            if (testListZip == null) {
                throw new RuntimeException("Failed to locate allowed test list " + testList);
            }
            File testListFile = null;
            try {
                ZipFile zipFile = new ZipFile(testListZip);
                testListFile = ZipUtil2.extractFileFromZip(zipFile, Files.getNameWithoutExtension(testList));
                zipFile.close();
                String content = FileUtil.readStringFromFile(testListFile);
                String pattern = "([^//]*).config$";
                Pattern namePattern = Pattern.compile("([^//]*).config$");
                for (String line : content.split("\n")) {
                    Matcher matcher = namePattern.matcher(line);
                    if (!matcher.find()) continue;
                    allowedTests.add(matcher.group(1));
                }
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException(String.format("IO exception (%s) when accessing allowed test list (%s)", e.getMessage(), testList), e);
                }
                catch (Throwable throwable) {
                    FileUtil.recursiveDelete(testListFile);
                    throw throwable;
                }
            }
            FileUtil.recursiveDelete(testListFile);
        }
        return testInfos.stream().filter(testInfo -> allowedTests.contains(testInfo.getName())).collect(Collectors.toSet());
    }

    private class TestInfoComparator
    implements Comparator<TestInfo> {
        private TestInfoComparator() {
        }

        @Override
        public int compare(TestInfo a, TestInfo b) {
            if (a.getNameOption().equals(b.getNameOption())) {
                return 0;
            }
            if (TestMappingSuiteRunner.createComparableNames(a).equals(b.getNameOption())) {
                return -1;
            }
            if (a.getNameOption().equals(TestMappingSuiteRunner.createComparableNames(b))) {
                return 1;
            }
            return 1;
        }
    }
}

