/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.suite;

import com.android.tradefed.log.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class TestSuiteInfo {
    private static final String SUITE_INFO_PROPERTY = "/test-suite-info.properties";
    private static final String BUILD_NUMBER = "build_number";
    private static final String TARGET_ARCH = "target_arch";
    private static final String NAME = "name";
    private static final String FULLNAME = "fullname";
    private static final String VERSION = "version";
    private static TestSuiteInfo sInstance;
    private Properties mTestSuiteInfo;
    private boolean mLoaded = false;

    private TestSuiteInfo() {
        try (InputStream is = TestSuiteInfo.class.getResourceAsStream(SUITE_INFO_PROPERTY);){
            if (is != null) {
                this.mTestSuiteInfo = this.loadSuiteInfo(is);
                this.mLoaded = true;
            } else {
                LogUtil.CLog.w("Unable to load suite info from jar resource %s, using stub info instead", SUITE_INFO_PROPERTY);
                this.mTestSuiteInfo = new Properties();
                this.mTestSuiteInfo.setProperty(BUILD_NUMBER, "[stub build number]");
                this.mTestSuiteInfo.setProperty(TARGET_ARCH, "[stub target arch]");
                this.mTestSuiteInfo.setProperty(NAME, "[stub name]");
                this.mTestSuiteInfo.setProperty(FULLNAME, "[stub fullname]");
                this.mTestSuiteInfo.setProperty(VERSION, "[stub version]");
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(String.format("error loading jar resource file \"%s\" for test suite info", SUITE_INFO_PROPERTY));
        }
    }

    protected Properties loadSuiteInfo(InputStream is) throws IOException {
        Properties p = new Properties();
        p.load(is);
        return p;
    }

    public static TestSuiteInfo getInstance() {
        if (sInstance == null) {
            sInstance = new TestSuiteInfo();
        }
        return sInstance;
    }

    public String getBuildNumber() {
        return this.mTestSuiteInfo.getProperty(BUILD_NUMBER);
    }

    public List<String> getTargetArchs() {
        String testInfoArch = this.mTestSuiteInfo.getProperty(TARGET_ARCH);
        ArrayList<String> targetArchs = new ArrayList<String>();
        targetArchs.addAll(Arrays.asList(testInfoArch.split(",")));
        return targetArchs;
    }

    public String getName() {
        return this.mTestSuiteInfo.getProperty(NAME);
    }

    public String getFullName() {
        return this.mTestSuiteInfo.getProperty(FULLNAME);
    }

    public String getVersion() {
        return this.mTestSuiteInfo.getProperty(VERSION);
    }

    public String get(String name) {
        return this.mTestSuiteInfo.getProperty(name);
    }

    public boolean didLoadFromProperties() {
        return this.mLoaded;
    }
}

