/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.suite;

import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.ConfigurationFactory;
import com.android.tradefed.config.ConfigurationUtil;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationFactory;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.multi.IMultiTargetPreparer;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.IAbiReceiver;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.suite.ITestSuite;
import com.android.tradefed.util.DirectedGraph;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.ZipUtil2;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class TfSuiteRunner
extends ITestSuite {
    private static final String CONFIG_EXT = ".config";
    @Option(name="run-suite-tag", description="The tag that must be run.", mandatory=true)
    private String mSuiteTag = null;
    @Option(name="suite-config-prefix", description="Search only configs with given prefix for suite tags.")
    private String mSuitePrefix = null;
    @Option(name="additional-tests-zip", description="Path to a zip file containing additional tests to be loaded.")
    private String mAdditionalTestsZip = null;
    private DirectedGraph<String> mLoadedConfigGraph = null;

    @Override
    public LinkedHashMap<String, IConfiguration> loadTests() {
        this.mLoadedConfigGraph = new DirectedGraph();
        return this.loadTests(null, this.mLoadedConfigGraph);
    }

    private LinkedHashMap<String, IConfiguration> loadTests(String parentConfig, DirectedGraph<String> graph) {
        IDeviceBuildInfo deviceBuildInfo;
        File testsDir;
        LinkedHashMap<String, IConfiguration> configMap = new LinkedHashMap<String, IConfiguration>();
        IConfigurationFactory configFactory = ConfigurationFactory.getInstance();
        List<String> configs = configFactory.getConfigList(this.mSuitePrefix, false);
        Set<IAbi> abis = null;
        if (this.getBuildInfo() instanceof IDeviceBuildInfo && (testsDir = (deviceBuildInfo = (IDeviceBuildInfo)this.getBuildInfo()).getTestsDir()) != null) {
            if (this.mAdditionalTestsZip != null) {
                LogUtil.CLog.d("Extract general-tests.zip (%s) to tests directory.", this.mAdditionalTestsZip);
                ZipFile zip = null;
                try {
                    zip = new ZipFile(this.mAdditionalTestsZip);
                    ZipUtil2.extractZip(zip, testsDir);
                }
                catch (IOException e) {
                    try {
                        RuntimeException runtimeException = new RuntimeException(String.format("IO error (%s) when unzipping general-tests.zip", e.toString()), e);
                        throw runtimeException;
                    }
                    catch (Throwable throwable) {
                        StreamUtil.close(zip);
                        throw throwable;
                    }
                }
                StreamUtil.close(zip);
            }
            LogUtil.CLog.d("Loading extra test configs from the tests directory: %s", testsDir.getAbsolutePath());
            List<File> extraTestCasesDirs = Arrays.asList(testsDir);
            configs.addAll(ConfigurationUtil.getConfigNamesFromDirs(this.mSuitePrefix, extraTestCasesDirs));
        }
        Collections.sort(configs);
        for (String configName : configs) {
            try {
                IConfiguration testConfig = configFactory.createConfigurationFromArgs(new String[]{configName});
                if (!testConfig.getConfigurationDescription().getSuiteTags().contains(this.mSuiteTag)) continue;
                if (this.canRunMultipleAbis(testConfig)) {
                    if (abis == null) {
                        try {
                            abis = this.getAbis(this.getDevice());
                        }
                        catch (DeviceNotAvailableException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    for (IAbi abi : abis) {
                        testConfig = configFactory.createConfigurationFromArgs(new String[]{configName});
                        String configNameAbi = abi.getName() + " " + configName;
                        for (IRemoteTest iRemoteTest : testConfig.getTests()) {
                            if (!(iRemoteTest instanceof IAbiReceiver)) continue;
                            ((IAbiReceiver)((Object)iRemoteTest)).setAbi(abi);
                        }
                        for (ITargetPreparer iTargetPreparer : testConfig.getTargetPreparers()) {
                            if (!(iTargetPreparer instanceof IAbiReceiver)) continue;
                            ((IAbiReceiver)((Object)iTargetPreparer)).setAbi(abi);
                        }
                        for (IMultiTargetPreparer iMultiTargetPreparer : testConfig.getMultiTargetPreparers()) {
                            if (!(iMultiTargetPreparer instanceof IAbiReceiver)) continue;
                            ((IAbiReceiver)((Object)iMultiTargetPreparer)).setAbi(abi);
                        }
                        LinkedHashMap<String, IConfiguration> expandedConfig = this.expandTestSuites(configNameAbi, testConfig, parentConfig, graph);
                        configMap.putAll(expandedConfig);
                    }
                    continue;
                }
                LinkedHashMap<String, IConfiguration> expandedConfig = this.expandTestSuites(configName, testConfig, parentConfig, graph);
                configMap.putAll(expandedConfig);
            }
            catch (ConfigurationException | NoClassDefFoundError e) {
                LogUtil.CLog.e("Configuration '%s' cannot be loaded, ignoring.", configName);
            }
        }
        return configMap;
    }

    private boolean canRunMultipleAbis(IConfiguration testConfig) {
        for (IRemoteTest iRemoteTest : testConfig.getTests()) {
            if (!(iRemoteTest instanceof IAbiReceiver)) continue;
            return true;
        }
        for (ITargetPreparer iTargetPreparer : testConfig.getTargetPreparers()) {
            if (!(iTargetPreparer instanceof IAbiReceiver)) continue;
            return true;
        }
        for (IMultiTargetPreparer iMultiTargetPreparer : testConfig.getMultiTargetPreparers()) {
            if (!(iMultiTargetPreparer instanceof IAbiReceiver)) continue;
            return true;
        }
        return false;
    }

    private LinkedHashMap<String, IConfiguration> expandTestSuites(String configName, IConfiguration config, String parentConfig, DirectedGraph<String> graph) {
        LinkedHashMap<String, IConfiguration> configMap = new LinkedHashMap<String, IConfiguration>();
        ArrayList<IRemoteTest> tests = new ArrayList<IRemoteTest>(config.getTests());
        if (parentConfig != null) {
            graph.addEdge(parentConfig, configName);
            if (!graph.isDag()) {
                LogUtil.CLog.e("%s", graph);
                throw new RuntimeException(String.format("Circular configuration detected: %s has been included several times.", configName));
            }
        }
        for (IRemoteTest test : tests) {
            if (!(test instanceof TfSuiteRunner)) continue;
            TfSuiteRunner runner = (TfSuiteRunner)test;
            if (runner.getSuiteTag() != null) {
                LinkedHashMap<String, IConfiguration> subConfigs = runner.loadTests(configName, graph);
                configMap.putAll(subConfigs);
            } else {
                LogUtil.CLog.w("Config %s does not have a suite-tag it cannot run anything.", configName);
            }
            config.getTests().remove(test);
        }
        if (!config.getTests().isEmpty()) {
            configMap.put(this.sanitizeConfigName(configName), config);
        }
        return configMap;
    }

    private String getSuiteTag() {
        return this.mSuiteTag;
    }

    private String sanitizeConfigName(String originalName) {
        if (originalName.contains(" ")) {
            String[] segments = originalName.split(" ");
            return segments[0] + " " + this.sanitizeModuleName(segments[1]);
        }
        return this.sanitizeModuleName(originalName);
    }

    private String sanitizeModuleName(String originalName) {
        if (originalName.endsWith(CONFIG_EXT)) {
            originalName = originalName.substring(0, originalName.length() - CONFIG_EXT.length());
        }
        if (!originalName.startsWith("/")) {
            return originalName;
        }
        String[] segments = originalName.split("/");
        if (segments.length < 3) {
            return originalName;
        }
        return String.join((CharSequence)"/", segments[segments.length - 2], segments[segments.length - 1]);
    }
}

