/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.suite;

import com.android.tradefed.build.StubBuildProvider;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IDeviceConfiguration;
import com.android.tradefed.device.metric.FilePullerLogCollector;
import com.android.tradefed.device.metric.IMetricCollector;
import com.android.tradefed.result.TextResultReporter;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.multi.IMultiTargetPreparer;
import com.android.tradefed.testtype.suite.module.BaseModuleController;
import com.android.tradefed.util.ModuleTestTypeUtil;
import java.util.ArrayList;
import java.util.List;

public class ValidateSuiteConfigHelper {
    private static final List<String> ALLOWED_COLLECTOR_IN_MODULE = new ArrayList<String>();

    private ValidateSuiteConfigHelper() {
    }

    public static void validateConfig(IConfiguration config) {
        List<?> controllers;
        if (config.getDeviceConfig().size() < 2) {
            if (!config.getBuildProvider().getClass().isAssignableFrom(StubBuildProvider.class)) {
                ValidateSuiteConfigHelper.throwRuntime(config, String.format("%s objects are not allowed in module.", "build_provider"));
            }
            ValidateSuiteConfigHelper.checkTargetPrep(config, config.getTargetPreparers());
        }
        for (IDeviceConfiguration deviceConfig : config.getDeviceConfig()) {
            if (!deviceConfig.getBuildProvider().getClass().isAssignableFrom(StubBuildProvider.class)) {
                ValidateSuiteConfigHelper.throwRuntime(config, String.format("%s objects are not allowed in module.", "build_provider"));
            }
            ValidateSuiteConfigHelper.checkTargetPrep(config, deviceConfig.getTargetPreparers());
        }
        if (config.getTestInvocationListeners().size() != 1) {
            ValidateSuiteConfigHelper.throwRuntime(config, String.format("%s objects are not allowed in module.", "result_reporter"));
        }
        if (!config.getTestInvocationListeners().get(0).getClass().isAssignableFrom(TextResultReporter.class)) {
            ValidateSuiteConfigHelper.throwRuntime(config, String.format("%s objects are not allowed in module.", "result_reporter"));
        }
        if (!config.getMultiPreTargetPreparers().isEmpty()) {
            ValidateSuiteConfigHelper.throwRuntime(config, String.format("%s objects are not allowed in module.", "multi_pre_target_preparer"));
        }
        ValidateSuiteConfigHelper.checkTargetPrep(config, config.getMultiTargetPreparers());
        if (!ModuleTestTypeUtil.isPerformanceModule(config)) {
            for (IMetricCollector collector : config.getMetricCollectors()) {
                if (ALLOWED_COLLECTOR_IN_MODULE.contains(collector.getClass().getCanonicalName())) continue;
                ValidateSuiteConfigHelper.throwRuntime(config, String.format("%s objects are not allowed in module. Except for: %s", "metrics_collector", ALLOWED_COLLECTOR_IN_MODULE));
            }
        }
        if (!config.getPostProcessors().isEmpty()) {
            ValidateSuiteConfigHelper.throwRuntime(config, String.format("%s objects are not allowed in module.", "metric_post_processor"));
        }
        if ((controllers = config.getConfigurationObjectList("module_controller")) != null) {
            for (Object controller : controllers) {
                if (controller instanceof BaseModuleController) continue;
                ValidateSuiteConfigHelper.throwRuntime(config, String.format("%s object should be of type %s", "module_controller", BaseModuleController.class));
            }
        }
    }

    private static boolean checkTargetPrep(IConfiguration config, List<?> targetPrepList) {
        for (Object o : targetPrepList) {
            if (!(o instanceof ITargetPreparer) || !(o instanceof IMultiTargetPreparer)) continue;
            ValidateSuiteConfigHelper.throwRuntime(config, String.format("%s is extending both %s and %s", o.getClass().getCanonicalName(), "target_preparer", "multi_target_preparer"));
            return false;
        }
        return true;
    }

    private static void throwRuntime(IConfiguration config, String msg) {
        throw new RuntimeException(String.format("Configuration %s cannot be run in a suite: %s", config.getName(), msg));
    }

    static {
        ALLOWED_COLLECTOR_IN_MODULE.add(FilePullerLogCollector.class.getCanonicalName());
    }
}

