/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.suite.module;

import com.android.tradefed.config.Option;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.testtype.suite.module.BaseModuleController;
import com.android.tradefed.testtype.suite.module.IModuleController;
import com.android.tradefed.util.AbiUtils;
import java.util.HashSet;
import java.util.Set;

public class ArchModuleController
extends BaseModuleController {
    @Option(name="arch", description="The architecture names that should run for this module.This should be like arm64, arm, x86_64, x86.", mandatory=true)
    private Set<String> mArches = new HashSet<String>();

    @Override
    public IModuleController.RunStrategy shouldRun(IInvocationContext context) {
        String moduleAbiName = this.getModuleAbi().getName();
        String moduleArchName = AbiUtils.getArchForAbi(moduleAbiName);
        if (this.mArches.contains(moduleArchName)) {
            return IModuleController.RunStrategy.RUN;
        }
        LogUtil.CLog.d("Skipping module %s running on abi %s, which doesn't match any required setting of %s.", this.getModuleName(), moduleAbiName, this.mArches);
        return IModuleController.RunStrategy.FULL_MODULE_BYPASS;
    }
}

