/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.suite.module;

import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.testtype.Abi;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.suite.module.IModuleController;
import com.android.tradefed.util.AbiUtils;

public abstract class BaseModuleController
implements IModuleController {
    @Option(name="bugreportz-on-failure", description="Module option to capture a bugreportz on its test failure.")
    private boolean mBugReportOnFailure = true;
    @Option(name="logcat-on-failure", description="Module option to capture a logcat on its test failure.")
    private boolean mLogcatOnFailure = true;
    @Option(name="screenshot-on-failure", description="Module option to capture a screenshot on its test failure.")
    private boolean mScreenshotOnFailure = true;
    private IInvocationContext mContext;

    @Override
    public final IModuleController.RunStrategy shouldRunModule(IInvocationContext context) throws DeviceNotAvailableException {
        this.mContext = context;
        return this.shouldRun(context);
    }

    public abstract IModuleController.RunStrategy shouldRun(IInvocationContext var1) throws DeviceNotAvailableException;

    public final IAbi getModuleAbi() {
        String abi = this.mContext.getAttributes().get("module-abi").get(0);
        return new Abi(abi, AbiUtils.getBitness(abi));
    }

    public final String getModuleName() {
        return this.mContext.getAttributes().get("module-name").get(0);
    }

    public final boolean shouldCaptureLogcat() {
        return this.mLogcatOnFailure;
    }

    public final boolean shouldCaptureScreenshot() {
        return this.mScreenshotOnFailure;
    }

    public final boolean shouldCaptureBugreport() {
        return this.mBugReportOnFailure;
    }
}

