/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.suite.module;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.testtype.suite.module.BaseModuleController;
import com.android.tradefed.testtype.suite.module.IModuleController;

public class CarModuleController
extends BaseModuleController {
    private static final String FEATURE_AUTOMOTIVE = "android.hardware.type.automotive";

    @Override
    public IModuleController.RunStrategy shouldRun(IInvocationContext context) {
        for (ITestDevice device : context.getDevices()) {
            if (device.getIDevice() instanceof StubDevice) continue;
            try {
                if (!device.hasFeature(FEATURE_AUTOMOTIVE)) continue;
                return IModuleController.RunStrategy.RUN;
            }
            catch (DeviceNotAvailableException e) {
                LogUtil.CLog.e("Couldn't check for automotive feature on %s", device.getSerialNumber());
                LogUtil.CLog.e(e);
            }
        }
        LogUtil.CLog.d("Bypassing module %s because it is only applicable to automotive.", this.getModuleName());
        return IModuleController.RunStrategy.FULL_MODULE_BYPASS;
    }
}

