/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.suite.module;

import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.testtype.suite.module.BaseModuleController;
import com.android.tradefed.testtype.suite.module.IModuleController;
import java.util.HashSet;
import java.util.Set;

public class DeviceFeatureModuleController
extends BaseModuleController {
    @Option(name="required-feature", description="Required feature for the test to run.")
    private Set<String> mRequiredFeatures = new HashSet<String>();
    @Option(name="forbidden-feature", description="Forbidden feature which will cause the test to be skipped.")
    private Set<String> mForbiddenFeatures = new HashSet<String>();

    @Override
    public IModuleController.RunStrategy shouldRun(IInvocationContext context) throws DeviceNotAvailableException {
        for (ITestDevice device : context.getDevices()) {
            if (device.getIDevice() instanceof StubDevice) continue;
            for (String feature : this.mRequiredFeatures) {
                if (device.hasFeature(feature)) continue;
                LogUtil.CLog.d("Skipping module %s because the device does not have feature %s.", this.getModuleName(), feature);
                return IModuleController.RunStrategy.FULL_MODULE_BYPASS;
            }
            for (String feature : this.mForbiddenFeatures) {
                if (!device.hasFeature(feature)) continue;
                LogUtil.CLog.d("Skipping module %s because the device has forbidden feature %s.", this.getModuleName(), feature);
                return IModuleController.RunStrategy.FULL_MODULE_BYPASS;
            }
        }
        return IModuleController.RunStrategy.RUN;
    }
}

