/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.suite.module;

import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.testtype.suite.module.BaseModuleController;
import com.android.tradefed.testtype.suite.module.IModuleController;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class MainlineTestModuleController
extends BaseModuleController {
    protected static final String GO_APEX_PREFIX = "com.google.android.go.";
    @Option(name="enable", description="Enable or disable this module controller.")
    private boolean mControllerEnabled = false;
    @Option(name="mainline-module-package-name", description="The mainline modules that must be preloaded in order torun the test module. Any matching module preloaded ontest device will cause the test module to be executed.")
    private List<String> mMainlineModules = new ArrayList<String>();
    private Set<ITestDevice.ApexInfo> mActiveApexes;

    @Override
    public IModuleController.RunStrategy shouldRun(IInvocationContext context) {
        if (!this.mControllerEnabled) {
            return IModuleController.RunStrategy.RUN;
        }
        if (this.mMainlineModules.isEmpty()) {
            LogUtil.CLog.i("MainlineTestModuleController is enabled, no mainlinemodule specified. Running test module: %s.", this.getModuleName());
            return IModuleController.RunStrategy.RUN;
        }
        for (ITestDevice device : context.getDevices()) {
            if (device.getIDevice() instanceof StubDevice) continue;
            try {
                boolean modulePreloaded = false;
                this.mActiveApexes = device.getActiveApexes();
                for (ITestDevice.ApexInfo ap : this.mActiveApexes) {
                    String pkgName = ap.name;
                    pkgName = pkgName.startsWith(GO_APEX_PREFIX) ? pkgName.replace(".go.", ".") : pkgName;
                    if (!this.mMainlineModules.contains(pkgName)) continue;
                    modulePreloaded = true;
                    break;
                }
                if (modulePreloaded) continue;
                LogUtil.CLog.i("Skipping test module %s because mainline module %s is not active.", this.getModuleName(), this.mMainlineModules.toString());
                return IModuleController.RunStrategy.FULL_MODULE_BYPASS;
            }
            catch (DeviceNotAvailableException e) {
                LogUtil.CLog.e("Skipping the test module %s.", this.getModuleName());
                LogUtil.CLog.e(e);
                return IModuleController.RunStrategy.FULL_MODULE_BYPASS;
            }
        }
        return IModuleController.RunStrategy.RUN;
    }

    public void enableModuleController(boolean enabled) {
        LogUtil.CLog.i("Enabling Mainline Test Module Controller");
        this.mControllerEnabled = enabled;
    }
}

