/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.suite.module;

import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.testtype.suite.module.BaseModuleController;
import com.android.tradefed.testtype.suite.module.IModuleController;

public class MinApiLevelModuleController
extends BaseModuleController {
    private static final String VNDK_PROP = "ro.vndk.version";
    @Option(name="api-level-prop", description="Read the api level from which prop. e.g.'ro.product.first_api_level'")
    private String mApiLevelProp = "ro.build.version.sdk";
    @Option(name="min-api-level", description="The minimum api-level on which tests will run.")
    private Integer mMinApiLevel = 0;

    @Override
    public IModuleController.RunStrategy shouldRun(IInvocationContext context) throws DeviceNotAvailableException {
        for (ITestDevice device : context.getDevices()) {
            if (device.getIDevice() instanceof StubDevice) continue;
            String apiLevelString = device.getProperty(this.mApiLevelProp);
            int apiLevel = -1;
            try {
                if (apiLevelString != null) {
                    apiLevel = Integer.parseInt(apiLevelString);
                } else {
                    LogUtil.CLog.d("Cannot get the API Level.");
                }
            }
            catch (NumberFormatException e) {
                if (VNDK_PROP.equals(this.mApiLevelProp)) {
                    apiLevel = 10000;
                }
                LogUtil.CLog.d("Error parsing system property %s: %s", this.mApiLevelProp, e.getMessage());
            }
            if (apiLevel >= this.mMinApiLevel) continue;
            LogUtil.CLog.d("Skipping module %s because API Level %d is < %d.", this.getModuleName(), apiLevel, this.mMinApiLevel);
            return IModuleController.RunStrategy.FULL_MODULE_BYPASS;
        }
        return IModuleController.RunStrategy.RUN;
    }
}

