/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.suite.module;

import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.testtype.suite.module.BaseModuleController;
import com.android.tradefed.testtype.suite.module.IModuleController;

public class MinSdkModuleController
extends BaseModuleController {
    private static final String SDK_VERSION_PROP = "ro.build.version.sdk";
    @Option(name="min-sdk-level", description="The minimum api-level on which tests will run.")
    private int mMinSdkVersion;

    protected MinSdkModuleController(int minSdkVersion) {
        this.mMinSdkVersion = minSdkVersion;
    }

    @Override
    public IModuleController.RunStrategy shouldRun(IInvocationContext context) throws DeviceNotAvailableException {
        for (ITestDevice device : context.getDevices()) {
            if (device.getIDevice() instanceof StubDevice) continue;
            String sdkVersionString = device.getProperty(SDK_VERSION_PROP);
            int sdkVersion = -1;
            try {
                if (sdkVersionString != null) {
                    sdkVersion = Integer.parseInt(sdkVersionString);
                } else {
                    LogUtil.CLog.d("SDK version is null");
                }
            }
            catch (NumberFormatException e) {
                LogUtil.CLog.d("Error parsing system property ro.build.version.sdk: " + e.getMessage());
            }
            if (sdkVersion >= this.mMinSdkVersion) continue;
            LogUtil.CLog.d("Skipping module %s because SDK version %d is < " + this.mMinSdkVersion + ".", this.getModuleName(), sdkVersion);
            return IModuleController.RunStrategy.FULL_MODULE_BYPASS;
        }
        return IModuleController.RunStrategy.RUN;
    }
}

