/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.suite.module;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.suite.module.BaseModuleController;
import com.android.tradefed.testtype.suite.module.IModuleController;
import com.android.tradefed.util.AbiFormatter;
import com.android.tradefed.util.AbiUtils;

public class NativeBridgeModuleController
extends BaseModuleController {
    public static final String NATIVE_BRIDGE_PROP = "ro.dalvik.vm.native.bridge";

    @Override
    public IModuleController.RunStrategy shouldRun(IInvocationContext context) {
        for (ITestDevice device : context.getDevices()) {
            if (device.getIDevice() instanceof StubDevice) continue;
            try {
                String bridge = device.getProperty(NATIVE_BRIDGE_PROP);
                if ("0".equals(bridge.trim())) continue;
                IAbi moduleAbi = this.getModuleAbi();
                String moduleArch = AbiUtils.getBaseArchForAbi(moduleAbi.getName());
                String primaryAbiString = AbiFormatter.getDefaultAbi(device, "");
                String deviceArch = AbiUtils.getBaseArchForAbi(primaryAbiString.trim());
                if (deviceArch.equals(moduleArch)) continue;
                LogUtil.CLog.d("Skipping module %s to avoid running the tests against the native bridge.", this.getModuleName());
                return IModuleController.RunStrategy.FULL_MODULE_BYPASS;
            }
            catch (DeviceNotAvailableException e) {
                LogUtil.CLog.e("Couldn't check native bridge on %s", device.getSerialNumber());
                LogUtil.CLog.e(e);
            }
        }
        return IModuleController.RunStrategy.RUN;
    }
}

