/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.suite.module;

import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.testtype.suite.module.BaseModuleController;
import com.android.tradefed.testtype.suite.module.IModuleController;
import java.util.HashSet;
import java.util.Set;

public class PackageInstalledModuleController
extends BaseModuleController {
    @Option(name="required-package", description="The packages that are required to run this module.")
    private Set<String> mPackages = new HashSet<String>();

    @Override
    public IModuleController.RunStrategy shouldRun(IInvocationContext context) throws DeviceNotAvailableException {
        for (ITestDevice device : context.getDevices()) {
            if (device.getIDevice() instanceof StubDevice) continue;
            Set<String> installedPackageNames = device.getInstalledPackageNames();
            for (String packageName : this.mPackages) {
                if (installedPackageNames.contains(packageName)) continue;
                LogUtil.CLog.d("Skipping module %s because the device does not have package %s.", this.getModuleName(), packageName);
                return IModuleController.RunStrategy.FULL_MODULE_BYPASS;
            }
        }
        return IModuleController.RunStrategy.RUN;
    }
}

