/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.suite.module;

import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.testtype.suite.module.BaseModuleController;
import com.android.tradefed.testtype.suite.module.IModuleController;

public class ShippingApiLevelModuleController
extends BaseModuleController {
    private static final String SYSTEM_SHIPPING_API_LEVEL_PROP = "ro.product.first_api_level";
    private static final String SYSTEM_API_LEVEL_PROP = "ro.build.version.sdk";
    private static final String VENDOR_SHIPPING_API_LEVEL_PROP = "ro.board.first_api_level";
    private static final String VENDOR_API_LEVEL_PROP = "ro.board.api_level";
    private static final long API_LEVEL_CURRENT = 10000L;
    @Option(name="min-api-level", description="The minimum shipping api-level of the device on which tests will run.")
    private Integer mMinApiLevel = 0;
    @Option(name="vsr-min-api-level", description="The minimum api-level on which tests will run. Both the shipping api-level of the device and the vendor api-level must be greater than or equal to the vsr-min-api-level to run the tests.")
    private Integer mVsrMinApiLevel = 0;

    private boolean shouldRunTestWithApiLevel(ITestDevice device, String apiLevelprop, String fallbackProp, int minApiLevel) throws DeviceNotAvailableException {
        String prop = apiLevelprop;
        long apiLevel = device.getIntProperty(prop, 10000L);
        if (apiLevel == 10000L) {
            prop = fallbackProp;
            apiLevel = device.getIntProperty(prop, 10000L);
        }
        if (apiLevel < (long)minApiLevel) {
            LogUtil.CLog.d("Skipping module %s because API Level %d from %s is less than %d.", this.getModuleName(), apiLevel, prop, minApiLevel);
            return false;
        }
        return true;
    }

    @Override
    public IModuleController.RunStrategy shouldRun(IInvocationContext context) throws DeviceNotAvailableException {
        for (ITestDevice device : context.getDevices()) {
            if (device.getIDevice() instanceof StubDevice) continue;
            if (!this.shouldRunTestWithApiLevel(device, SYSTEM_SHIPPING_API_LEVEL_PROP, SYSTEM_API_LEVEL_PROP, this.mMinApiLevel)) {
                return IModuleController.RunStrategy.FULL_MODULE_BYPASS;
            }
            if (!this.shouldRunTestWithApiLevel(device, SYSTEM_SHIPPING_API_LEVEL_PROP, SYSTEM_API_LEVEL_PROP, this.mVsrMinApiLevel)) {
                return IModuleController.RunStrategy.FULL_MODULE_BYPASS;
            }
            if (this.shouldRunTestWithApiLevel(device, VENDOR_API_LEVEL_PROP, VENDOR_SHIPPING_API_LEVEL_PROP, this.mVsrMinApiLevel)) continue;
            return IModuleController.RunStrategy.FULL_MODULE_BYPASS;
        }
        return IModuleController.RunStrategy.RUN;
    }
}

