/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.suite.params;

import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IDeviceConfiguration;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.TestAppInstallSetup;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.ITestAnnotationFilterReceiver;
import com.android.tradefed.testtype.suite.params.IModuleParameterHandler;
import java.util.HashSet;

public class InstantAppHandler
implements IModuleParameterHandler {
    public static final String INSTANT_APP_ID = "instant";

    @Override
    public String getParameterIdentifier() {
        return INSTANT_APP_ID;
    }

    @Override
    public void applySetup(IConfiguration moduleConfiguration) {
        for (IDeviceConfiguration deviceConfig : moduleConfiguration.getDeviceConfig()) {
            for (ITargetPreparer preparer : deviceConfig.getTargetPreparers()) {
                if (!(preparer instanceof TestAppInstallSetup)) continue;
                ((TestAppInstallSetup)preparer).setInstantMode(true);
            }
        }
        for (IRemoteTest test : moduleConfiguration.getTests()) {
            if (!(test instanceof ITestAnnotationFilterReceiver)) continue;
            ITestAnnotationFilterReceiver filterTest = (ITestAnnotationFilterReceiver)((Object)test);
            HashSet<String> excludeAnnotations = new HashSet<String>(filterTest.getExcludeAnnotations());
            excludeAnnotations.remove("android.platform.test.annotations.AppModeInstant");
            excludeAnnotations.add("android.platform.test.annotations.AppModeFull");
            filterTest.clearExcludeAnnotations();
            filterTest.addAllExcludeAnnotation(excludeAnnotations);
        }
    }
}

