/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.suite.params;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IDeviceConfiguration;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.InstallApexModuleTargetPreparer;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.suite.module.MainlineTestModuleController;
import com.android.tradefed.util.AbiUtils;
import java.util.Arrays;
import java.util.List;

public final class MainlineModuleHandler {
    private String mDynamicBaseLink = null;
    private IAbi mAbi = null;
    private String mName = null;
    private boolean mOptimizeMainlineTest = false;
    private boolean mIgnoreNonPreloadedMainlineModule = false;
    private String mBuildTop = System.getenv("ANDROID_BUILD_TOP");

    public MainlineModuleHandler(String name, IAbi abi, IInvocationContext context, boolean optimize) {
        this(name, abi, context, optimize, false);
    }

    public MainlineModuleHandler(String name, IAbi abi, IInvocationContext context, boolean optimize, boolean ignoreNonPreloadedMainlineModule) {
        this.mName = name;
        this.mAbi = abi;
        this.buildDynamicBaseLink(context.getBuildInfos().get(0));
        this.mOptimizeMainlineTest = optimize;
        this.mIgnoreNonPreloadedMainlineModule = ignoreNonPreloadedMainlineModule;
    }

    MainlineModuleHandler(String name, String buildTop, IAbi abi, IInvocationContext context) {
        this.mName = name;
        this.mBuildTop = buildTop;
        this.mAbi = abi;
        this.buildDynamicBaseLink(context.getBuildInfos().get(0));
    }

    private void buildDynamicBaseLink(IBuildInfo buildInfo) {
        if (buildInfo == null) {
            throw new IllegalArgumentException("Missing build information when enable-mainline-parameterized-modules is set.");
        }
        if (this.mBuildTop == null) {
            String buildBranch = buildInfo.getBuildBranch();
            String buildFlavor = buildInfo.getBuildFlavor();
            String buildId = buildInfo.getBuildId();
            if (buildBranch == null || buildFlavor == null || buildId == null) {
                throw new IllegalArgumentException("Missing required information to build the dynamic base link.");
            }
            LogUtil.CLog.i("Building the dynamic base link based on the build information.");
            this.mDynamicBaseLink = String.format("ab://%s/%s/%s", buildBranch, buildFlavor, buildId);
        } else {
            LogUtil.CLog.i("Building the dynamic base link from local artifacts.");
            this.mDynamicBaseLink = String.format("%s/%s", this.mBuildTop, "out/dist");
        }
    }

    public void applySetup(IConfiguration moduleConfiguration) {
        List<?> ctrlObjectList = moduleConfiguration.getConfigurationObjectList("module_controller");
        if (ctrlObjectList != null) {
            for (Object ctrlObject : ctrlObjectList) {
                if (!(ctrlObject instanceof MainlineTestModuleController)) continue;
                ((MainlineTestModuleController)ctrlObject).enableModuleController(true);
            }
        }
        for (IDeviceConfiguration deviceConfig : moduleConfiguration.getDeviceConfig()) {
            List<ITargetPreparer> preparers = deviceConfig.getTargetPreparers();
            preparers.add(0, this.createMainlineModuleInstaller());
        }
    }

    private InstallApexModuleTargetPreparer createMainlineModuleInstaller() {
        InstallApexModuleTargetPreparer mainlineModuleInstaller = new InstallApexModuleTargetPreparer();
        mainlineModuleInstaller.setSkipApexTearDown(this.mOptimizeMainlineTest);
        mainlineModuleInstaller.setIgnoreIfNotPreloaded(this.mIgnoreNonPreloadedMainlineModule);
        String fullDynamicLink = this.mDynamicBaseLink;
        for (String mainlineModule : Arrays.asList(this.mName.split(String.format("\\+", new Object[0])))) {
            if (!mainlineModule.endsWith(".apks")) {
                fullDynamicLink = String.format("%s/mainline_modules_%s", this.mDynamicBaseLink, AbiUtils.getArchForAbi(this.mAbi.getName()));
            }
            mainlineModuleInstaller.addTestFileName(String.format("%s/%s", fullDynamicLink, mainlineModule));
        }
        return mainlineModuleInstaller;
    }
}

