/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.suite.params;

import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IDeviceConfiguration;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.CreateUserPreparer;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.RunCommandTargetPreparer;
import com.android.tradefed.targetprep.VisibleBackgroundUserPreparer;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.ITestAnnotationFilterReceiver;
import com.android.tradefed.testtype.suite.params.IModuleParameterHandler;
import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;

public class SecondaryUserHandler
implements IModuleParameterHandler {
    @VisibleForTesting
    static final List<String> LOCATION_COMMANDS = Arrays.asList("settings put secure location_providers_allowed +network", "settings put secure location_providers_allowed +gps");
    private final boolean mStartUserVisibleOnBackground;
    @Nullable
    private final Integer mDisplayId;

    public SecondaryUserHandler() {
        this(false);
    }

    protected SecondaryUserHandler(boolean startUserVisibleOnBackground) {
        this(startUserVisibleOnBackground, null);
    }

    protected SecondaryUserHandler(boolean startUserVisibleOnBackground, Integer displayId) {
        this.mStartUserVisibleOnBackground = startUserVisibleOnBackground;
        this.mDisplayId = displayId;
    }

    @Override
    public String getParameterIdentifier() {
        return "secondary_user";
    }

    @Override
    public final void addParameterSpecificConfig(IConfiguration moduleConfiguration) {
        for (IDeviceConfiguration deviceConfig : moduleConfiguration.getDeviceConfig()) {
            BaseTargetPreparer userPreparer;
            List<ITargetPreparer> preparers = deviceConfig.getTargetPreparers();
            if (this.mStartUserVisibleOnBackground) {
                userPreparer = new VisibleBackgroundUserPreparer();
                if (this.mDisplayId != null) {
                    ((VisibleBackgroundUserPreparer)userPreparer).setDisplayId(this.mDisplayId);
                }
            } else {
                userPreparer = new CreateUserPreparer();
            }
            preparers.add(0, userPreparer);
            RunCommandTargetPreparer locationPreparer = new RunCommandTargetPreparer();
            LOCATION_COMMANDS.forEach(cmd -> locationPreparer.addRunCommand((String)cmd));
            preparers.add(1, locationPreparer);
        }
    }

    @Override
    public final void applySetup(IConfiguration moduleConfiguration) {
        for (IRemoteTest test : moduleConfiguration.getTests()) {
            if (!(test instanceof ITestAnnotationFilterReceiver)) continue;
            ITestAnnotationFilterReceiver filterTest = (ITestAnnotationFilterReceiver)((Object)test);
            HashSet<String> excludeAnnotations = new HashSet<String>(filterTest.getExcludeAnnotations());
            excludeAnnotations.add("android.platform.test.annotations.SystemUserOnly");
            filterTest.clearExcludeAnnotations();
            filterTest.addAllExcludeAnnotation(excludeAnnotations);
        }
    }
}

