/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.suite.params.multiuser;

import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IDeviceConfiguration;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.ProfileTargetPreparer;
import com.android.tradefed.targetprep.RunOnSystemUserTargetPreparer;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.ITestAnnotationFilterReceiver;
import com.android.tradefed.testtype.suite.module.IModuleController;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public abstract class ProfileParameterHandler {
    private final String mRequireRunOnProfileAnnotation;
    private final ProfileTargetPreparer mProfileTargetPreparer;
    private final List<IModuleController> mModuleControllers;

    ProfileParameterHandler(String requireRunOnProfileAnnotation, ProfileTargetPreparer profileTargetPreparer) {
        this(requireRunOnProfileAnnotation, profileTargetPreparer, new ArrayList<IModuleController>());
    }

    ProfileParameterHandler(String requireRunOnProfileAnnotation, ProfileTargetPreparer profileTargetPreparer, List<IModuleController> moduleControllers) {
        this.mRequireRunOnProfileAnnotation = requireRunOnProfileAnnotation;
        this.mProfileTargetPreparer = profileTargetPreparer;
        this.mModuleControllers = moduleControllers;
    }

    public void addParameterSpecificConfig(IConfiguration moduleConfiguration) {
        for (IDeviceConfiguration deviceConfig : moduleConfiguration.getDeviceConfig()) {
            List<ITargetPreparer> preparers = deviceConfig.getTargetPreparers();
            preparers.add(0, this.mProfileTargetPreparer);
            preparers.removeIf(preparer -> preparer instanceof RunOnSystemUserTargetPreparer);
        }
    }

    public void applySetup(IConfiguration moduleConfiguration) {
        this.addModuleControllersToConfiguration(moduleConfiguration, this.mModuleControllers);
        for (IRemoteTest test : moduleConfiguration.getTests()) {
            if (!(test instanceof ITestAnnotationFilterReceiver)) continue;
            ITestAnnotationFilterReceiver filterTest = (ITestAnnotationFilterReceiver)((Object)test);
            filterTest.clearIncludeAnnotations();
            filterTest.addIncludeAnnotation(this.mRequireRunOnProfileAnnotation);
            HashSet<String> excludeAnnotations = new HashSet<String>(filterTest.getExcludeAnnotations());
            excludeAnnotations.remove(this.mRequireRunOnProfileAnnotation);
            filterTest.clearExcludeAnnotations();
            filterTest.addAllExcludeAnnotation(excludeAnnotations);
        }
    }

    private void addModuleControllersToConfiguration(IConfiguration moduleConfiguration, List<IModuleController> moduleControllers) {
        if (moduleControllers == null || moduleControllers.isEmpty()) {
            return;
        }
        List<?> ctrlObjectList = moduleConfiguration.getConfigurationObjectList("module_controller");
        if (ctrlObjectList == null) {
            ctrlObjectList = new ArrayList();
        }
        HashSet ctrlObjectSet = new HashSet(ctrlObjectList);
        for (IModuleController moduleController : moduleControllers) {
            ctrlObjectSet.add(moduleController);
        }
        try {
            moduleConfiguration.setConfigurationObjectList("module_controller", new ArrayList(ctrlObjectSet));
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

