/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.suite.params.multiuser;

import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IDeviceConfiguration;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.RunOnSecondaryUserTargetPreparer;
import com.android.tradefed.targetprep.RunOnSystemUserTargetPreparer;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.ITestAnnotationFilterReceiver;
import com.android.tradefed.testtype.suite.params.IModuleParameterHandler;
import java.util.HashSet;
import java.util.List;

public class RunOnSecondaryUserParameterHandler
implements IModuleParameterHandler {
    private static final String REQUIRE_RUN_ON_SECONDARY_USER_NAME = "com.android.bedstead.harrier.annotations.RequireRunOnSecondaryUser";

    @Override
    public String getParameterIdentifier() {
        return "run-on-secondary-user";
    }

    @Override
    public void addParameterSpecificConfig(IConfiguration moduleConfiguration) {
        for (IDeviceConfiguration deviceConfig : moduleConfiguration.getDeviceConfig()) {
            List<ITargetPreparer> preparers = deviceConfig.getTargetPreparers();
            preparers.add(0, new RunOnSecondaryUserTargetPreparer());
            preparers.removeIf(preparer -> preparer instanceof RunOnSystemUserTargetPreparer);
        }
    }

    @Override
    public void applySetup(IConfiguration moduleConfiguration) {
        for (IRemoteTest test : moduleConfiguration.getTests()) {
            if (!(test instanceof ITestAnnotationFilterReceiver)) continue;
            ITestAnnotationFilterReceiver filterTest = (ITestAnnotationFilterReceiver)((Object)test);
            filterTest.clearIncludeAnnotations();
            filterTest.addIncludeAnnotation(REQUIRE_RUN_ON_SECONDARY_USER_NAME);
            HashSet<String> excludeAnnotations = new HashSet<String>(filterTest.getExcludeAnnotations());
            excludeAnnotations.remove(REQUIRE_RUN_ON_SECONDARY_USER_NAME);
            filterTest.clearExcludeAnnotations();
            filterTest.addAllExcludeAnnotation(excludeAnnotations);
        }
    }
}

