/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.suite.retry;

import com.android.ddmlib.Log;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.ILogSaverListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.TestResult;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.util.TimeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ResultsPlayer
implements IRemoteTest,
IConfigurationReceiver {
    public static final String REPLAY_DONE = "REPLAY_DONE";
    private Map<TestRunResult, ReplayModuleHolder> mModuleResult;
    private IConfiguration mConfiguration;
    private boolean mCompleted;

    public ResultsPlayer() {
        this.mModuleResult = new LinkedHashMap<TestRunResult, ReplayModuleHolder>();
    }

    public ResultsPlayer(boolean completed) {
        this.mCompleted = completed;
    }

    @Override
    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        for (ITestDevice device : testInfo.getContext().getDevices()) {
            if (device.getIDevice() instanceof StubDevice) continue;
            device.waitForDeviceAvailable();
        }
        testInfo.getContext().getBuildInfos().get(0).addBuildAttribute(REPLAY_DONE, "false");
        long startReplay = System.currentTimeMillis();
        LogUtil.CLog.logAndDisplay(Log.LogLevel.DEBUG, "Start replaying the previous results. Please wait this can take a few minutes.");
        Log.LogLevel originalLevel = this.mConfiguration.getLogOutput().getLogLevel();
        this.mConfiguration.getLogOutput().setLogLevel(Log.LogLevel.WARN);
        Set<Map.Entry<TestRunResult, ReplayModuleHolder>> entries = this.mModuleResult.entrySet();
        for (Map.Entry entry : new LinkedHashSet<Map.Entry<TestRunResult, ReplayModuleHolder>>(entries)) {
            Collection<Map.Entry<TestDescription, TestResult>> testSet;
            TestRunResult module = (TestRunResult)entry.getKey();
            ReplayModuleHolder holder = (ReplayModuleHolder)entry.getValue();
            this.mModuleResult.remove(module);
            IInvocationContext moduleContext = holder.mModuleContext;
            if (moduleContext != null) {
                for (String deviceName : testInfo.getContext().getDeviceConfigNames()) {
                    moduleContext.addAllocatedDevice(deviceName, testInfo.getContext().getDevice(deviceName));
                    moduleContext.addDeviceBuildInfo(deviceName, testInfo.getContext().getBuildInfo(deviceName));
                }
                listener.testModuleStarted(moduleContext);
            }
            if ((testSet = holder.mResults).isEmpty()) {
                testSet = module.getTestResults().entrySet();
            }
            this.forwardTestResults(module, testSet, listener);
            if (moduleContext != null) {
                listener.testModuleEnded();
            }
            holder.mResults.clear();
            module.getTestResults().clear();
        }
        this.mConfiguration.getLogOutput().setLogLevel(originalLevel);
        LogUtil.CLog.logAndDisplay(Log.LogLevel.DEBUG, "Done replaying results in %s", TimeUtil.formatElapsedTime(System.currentTimeMillis() - startReplay));
        this.mModuleResult.clear();
        this.mCompleted = true;
        testInfo.getContext().getBuildInfos().get(0).removeBuildAttribute(REPLAY_DONE);
        testInfo.getContext().getBuildInfos().get(0).addBuildAttribute(REPLAY_DONE, "true");
    }

    void addToReplay(IInvocationContext moduleContext, TestRunResult module, Map.Entry<TestDescription, TestResult> testResult) {
        ReplayModuleHolder holder = this.mModuleResult.get(module);
        if (holder == null) {
            holder = new ReplayModuleHolder();
            holder.mModuleContext = moduleContext;
            this.mModuleResult.put(module, holder);
        }
        if (testResult != null) {
            holder.mResults.add(testResult);
        }
    }

    @Override
    public void setConfiguration(IConfiguration configuration) {
        this.mConfiguration = configuration;
    }

    public boolean completed() {
        return this.mCompleted;
    }

    private void forwardTestResults(TestRunResult module, Collection<Map.Entry<TestDescription, TestResult>> testSet, ITestInvocationListener listener) {
        listener.testRunStarted(module.getName(), testSet.size());
        for (Map.Entry<TestDescription, TestResult> testEntry : testSet) {
            listener.testStarted(testEntry.getKey(), testEntry.getValue().getStartTime());
            switch (testEntry.getValue().getStatus()) {
                case FAILURE: {
                    listener.testFailed(testEntry.getKey(), testEntry.getValue().getStackTrace());
                    break;
                }
                case ASSUMPTION_FAILURE: {
                    listener.testAssumptionFailure(testEntry.getKey(), testEntry.getValue().getStackTrace());
                    break;
                }
                case IGNORED: {
                    listener.testIgnored(testEntry.getKey());
                    break;
                }
                case INCOMPLETE: {
                    listener.testFailed(testEntry.getKey(), "Test did not complete due to exception.");
                    break;
                }
            }
            for (Map.Entry<String, LogFile> logFile : testEntry.getValue().getLoggedFiles().entrySet()) {
                if (!(listener instanceof ILogSaverListener)) continue;
                ((ILogSaverListener)listener).logAssociation(logFile.getKey(), logFile.getValue());
            }
            HashMap<String, MetricMeasurement.Metric> metrics = testEntry.getValue().getProtoMetrics();
            metrics.put("cached", MetricMeasurement.Metric.newBuilder().setMeasurements(MetricMeasurement.Measurements.newBuilder().setSingleString("true")).build());
            listener.testEnded(testEntry.getKey(), testEntry.getValue().getEndTime(), metrics);
        }
        if (module.isRunFailure()) {
            listener.testRunFailed(module.getRunFailureMessage());
        }
        listener.testRunEnded(module.getElapsedTime(), module.getRunProtoMetrics());
    }

    private class ReplayModuleHolder {
        public IInvocationContext mModuleContext;
        public List<Map.Entry<TestDescription, TestResult>> mResults = new ArrayList<Map.Entry<TestDescription, TestResult>>();

        private ReplayModuleHolder() {
        }
    }
}

