/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.suite.retry;

import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.ConfigurationFactory;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationFactory;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.IDeviceSelection;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.FileLogger;
import com.android.tradefed.log.ILeveledLogOutput;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.TestResult;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.result.TextResultReporter;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.suite.BaseTestSuite;
import com.android.tradefed.testtype.suite.SuiteTestFilter;
import com.android.tradefed.testtype.suite.retry.ITestSuiteResultLoader;
import com.android.tradefed.testtype.suite.retry.ResultsPlayer;
import com.android.tradefed.testtype.suite.retry.RetryResultHelper;
import com.android.tradefed.util.AbiUtils;
import com.android.tradefed.util.QuotationAwareTokenizer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;

public final class RetryRescheduler
implements IRemoteTest,
IConfigurationReceiver {
    @Option(name="retry-type", description="used to retry tests of a certain status. Possible values include \"failed\" and \"not_executed\".")
    private RetryType mRetryType = null;
    @Option(name="new-parameterized-handling", description="Feature flag to test out the newer parameterized method handling for retry.")
    private boolean mParameterizedHandling = false;
    @Option(name="module", shortName=109, description="the test module to run. Only works for configuration in the tests dir.")
    private String mModuleName = null;
    @Option(name="exclude-filter", description="the exclude module filters to apply.", importance=Option.Importance.ALWAYS)
    private Set<String> mExcludeFilters = new HashSet<String>();
    public static final String PREVIOUS_LOADER_NAME = "previous_loader";
    private IConfiguration mConfiguration;
    private IConfigurationFactory mFactory;
    private IConfiguration mRescheduledConfiguration;

    @Override
    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        IConfiguration originalConfig;
        Assert.assertNull(testInfo);
        Assert.assertNull(listener);
        Object loader = this.mConfiguration.getConfigurationObject(PREVIOUS_LOADER_NAME);
        if (loader == null) {
            throw new RuntimeException(String.format("An <object> of type %s was expected in the retry.", PREVIOUS_LOADER_NAME));
        }
        if (!(loader instanceof ITestSuiteResultLoader)) {
            throw new RuntimeException(String.format("%s should be implementing %s", loader.getClass().getCanonicalName(), ITestSuiteResultLoader.class.getCanonicalName()));
        }
        ITestSuiteResultLoader previousLoader = (ITestSuiteResultLoader)loader;
        previousLoader.init();
        String commandLine = previousLoader.getCommandLine();
        try {
            originalConfig = this.getFactory().createConfigurationFromArgs(QuotationAwareTokenizer.tokenizeLine(commandLine));
            originalConfig.getCommandOptions().setShardCount(this.mConfiguration.getCommandOptions().getShardCount());
            originalConfig.getCommandOptions().setShardIndex(this.mConfiguration.getCommandOptions().getShardIndex());
            IDeviceSelection requirements = this.mConfiguration.getDeviceRequirements();
            originalConfig.setDeviceRequirements(requirements);
            ILeveledLogOutput originalLogger = originalConfig.getLogOutput();
            ILeveledLogOutput retryLogger = this.mConfiguration.getLogOutput();
            originalLogger.setLogLevel(retryLogger.getLogLevel());
            if (originalLogger instanceof FileLogger && retryLogger instanceof FileLogger) {
                ((FileLogger)originalLogger).setLogLevelDisplay(((FileLogger)retryLogger).getLogLevelDisplay());
            }
            this.handleExtraResultReporter(originalConfig, this.mConfiguration);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        CollectingTestListener collectedTests = previousLoader.loadPreviousResults();
        previousLoader.cleanUp();
        IRemoteTest test = originalConfig.getTests().get(0);
        if (!(test instanceof BaseTestSuite)) {
            throw new RuntimeException("RetryScheduler only works for BaseTestSuite implementations");
        }
        BaseTestSuite suite = (BaseTestSuite)test;
        ResultsPlayer replayer = new ResultsPlayer();
        this.updateRunner(suite, collectedTests, replayer);
        collectedTests = null;
        this.updateConfiguration(originalConfig, replayer);
        this.customizeConfig(previousLoader, originalConfig);
        this.mRescheduledConfiguration = originalConfig;
    }

    @Override
    public void setConfiguration(IConfiguration configuration) {
        this.mConfiguration = configuration;
    }

    private IConfigurationFactory getFactory() {
        if (this.mFactory != null) {
            return this.mFactory;
        }
        return ConfigurationFactory.getInstance();
    }

    void setConfigurationFactory(IConfigurationFactory factory) {
        this.mFactory = factory;
    }

    public final IConfiguration getRetryConfiguration() {
        return this.mRescheduledConfiguration;
    }

    private void updateRunner(BaseTestSuite suite, CollectingTestListener results, ResultsPlayer replayer) {
        ArrayList<RetryType> types = new ArrayList<RetryType>();
        if (this.mRetryType == null) {
            types.add(RetryType.FAILED);
            types.add(RetryType.NOT_EXECUTED);
        } else {
            types.add(this.mRetryType);
        }
        HashSet<String> expandedModuleOption = new HashSet<String>();
        if (this.mModuleName != null) {
            SuiteTestFilter moduleFilter = SuiteTestFilter.createFrom(this.mModuleName);
            expandedModuleOption.add(this.mModuleName);
            if (moduleFilter.getAbi() == null) {
                Set<String> abis = AbiUtils.getAbisSupportedByCompatibility();
                for (String abi : abis) {
                    SuiteTestFilter namingFilter = new SuiteTestFilter(abi, moduleFilter.getName(), moduleFilter.getTest());
                    expandedModuleOption.add(namingFilter.toString());
                }
            }
        }
        HashSet<String> extendedExcludeRetryFilters = new HashSet<String>();
        for (String excludeFilter : this.mExcludeFilters) {
            SuiteTestFilter suiteFilter = SuiteTestFilter.createFrom(excludeFilter);
            extendedExcludeRetryFilters.add(excludeFilter);
            if (suiteFilter.getAbi() != null) continue;
            Set<String> abis = AbiUtils.getAbisSupportedByCompatibility();
            for (String abi : abis) {
                SuiteTestFilter namingFilter = new SuiteTestFilter(abi, suiteFilter.getName(), suiteFilter.getTest());
                extendedExcludeRetryFilters.add(namingFilter.toString());
            }
        }
        for (TestRunResult moduleResult : results.getMergedTestRunResults()) {
            if (!extendedExcludeRetryFilters.contains(moduleResult.getName()) && (expandedModuleOption.isEmpty() || expandedModuleOption.contains(moduleResult.getName())) && RetryResultHelper.shouldRunModule(moduleResult, types)) {
                if (types.contains((Object)RetryType.NOT_EXECUTED)) {
                    moduleResult.resetRunFailure();
                }
                LinkedHashMap<TestDescription, TestResult> parameterizedMethods = new LinkedHashMap<TestDescription, TestResult>();
                for (Map.Entry<TestDescription, TestResult> entry : moduleResult.getTestResults().entrySet()) {
                    if (!this.mParameterizedHandling && this.isParameterized(entry.getKey())) {
                        parameterizedMethods.put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    if (RetryResultHelper.shouldRunTest(entry.getValue(), types)) continue;
                    this.addExcludeToConfig(suite, moduleResult, entry.getKey().toString());
                    replayer.addToReplay(results.getModuleContextForRunResult(moduleResult.getName()), moduleResult, entry);
                }
                if (this.mParameterizedHandling) continue;
                for (Map.Entry<Object, Object> entry : this.sortMethodToClass(parameterizedMethods).entrySet()) {
                    boolean shouldNotrerunAnything = ((Map)entry.getValue()).entrySet().stream().noneMatch(v -> RetryResultHelper.shouldRunTest((TestResult)v.getValue(), types));
                    if (!shouldNotrerunAnything) continue;
                    this.addExcludeToConfig(suite, moduleResult, (String)entry.getKey());
                    for (Map.Entry<TestDescription, TestResult> entry2 : ((Map)entry.getValue()).entrySet()) {
                        replayer.addToReplay(results.getModuleContextForRunResult(moduleResult.getName()), moduleResult, entry2);
                    }
                }
                continue;
            }
            this.addExcludeToConfig(suite, moduleResult, null);
            replayer.addToReplay(results.getModuleContextForRunResult(moduleResult.getName()), moduleResult, null);
        }
    }

    private void updateConfiguration(IConfiguration config, ResultsPlayer replayer) {
        List<IRemoteTest> tests = config.getTests();
        ArrayList<IRemoteTest> newList = new ArrayList<IRemoteTest>();
        newList.add(replayer);
        newList.addAll(tests);
        config.setTests(newList);
    }

    private void customizeConfig(ITestSuiteResultLoader loader, IConfiguration originalConfig) {
        loader.customizeConfiguration(originalConfig);
    }

    private void addExcludeToConfig(BaseTestSuite suite, TestRunResult moduleResult, String testDescription) {
        String filter = moduleResult.getName();
        if (testDescription != null) {
            filter = String.format("%s %s", filter, testDescription);
        }
        SuiteTestFilter testFilter = SuiteTestFilter.createFrom(filter);
        LinkedHashSet<String> excludeFilter = new LinkedHashSet<String>();
        excludeFilter.add(testFilter.toString());
        suite.setExcludeFilter(excludeFilter);
    }

    private boolean isParameterized(TestDescription description) {
        return !description.getTestName().equals(description.getTestNameWithoutParams());
    }

    private Map<String, Map<TestDescription, TestResult>> sortMethodToClass(Map<TestDescription, TestResult> paramMethods) {
        LinkedHashMap<String, Map<TestDescription, TestResult>> returnMap = new LinkedHashMap<String, Map<TestDescription, TestResult>>();
        for (Map.Entry<TestDescription, TestResult> entry : paramMethods.entrySet()) {
            String noParamName = String.format("%s#%s", entry.getKey().getClassName(), entry.getKey().getTestNameWithoutParams());
            LinkedHashMap<TestDescription, TestResult> forClass = (LinkedHashMap<TestDescription, TestResult>)returnMap.get(noParamName);
            if (forClass == null) {
                forClass = new LinkedHashMap<TestDescription, TestResult>();
                returnMap.put(noParamName, forClass);
            }
            forClass.put(entry.getKey(), entry.getValue());
        }
        return returnMap;
    }

    private void handleExtraResultReporter(IConfiguration originalConfig, IConfiguration retryConfig) {
        if (retryConfig.getTestInvocationListeners().size() == 1 && this.mConfiguration.getTestInvocationListeners().get(0) instanceof TextResultReporter) {
            return;
        }
        List<ITestInvocationListener> listeners = originalConfig.getTestInvocationListeners();
        listeners.addAll(retryConfig.getTestInvocationListeners());
        originalConfig.setTestInvocationListeners(listeners);
    }

    public static enum RetryType {
        FAILED,
        NOT_EXECUTED;

    }
}

