/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.suite.retry;

import com.android.ddmlib.testrunner.TestResult;
import com.android.tradefed.result.TestResult;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.testtype.suite.retry.RetryRescheduler;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class RetryResultHelper {
    public static boolean shouldRunModule(TestRunResult moduleResults, List<RetryRescheduler.RetryType> types) {
        if (moduleResults.isRunFailure() && types.contains((Object)RetryRescheduler.RetryType.NOT_EXECUTED)) {
            return true;
        }
        for (TestResult.TestStatus status : RetryResultHelper.getStatusesToRun(types)) {
            if (moduleResults.getNumTestsInState(status) <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean shouldRunTest(TestResult result, List<RetryRescheduler.RetryType> types) {
        return RetryResultHelper.getStatusesToRun(types).contains((Object)result.getStatus());
    }

    private static Set<TestResult.TestStatus> getStatusesToRun(List<RetryRescheduler.RetryType> types) {
        LinkedHashSet<TestResult.TestStatus> statusesToRun = new LinkedHashSet<TestResult.TestStatus>();
        if (types.contains((Object)RetryRescheduler.RetryType.FAILED)) {
            statusesToRun.add(TestResult.TestStatus.FAILURE);
            statusesToRun.add(TestResult.TestStatus.INCOMPLETE);
        }
        if (types.contains((Object)RetryRescheduler.RetryType.NOT_EXECUTED)) {
            statusesToRun.add(TestResult.TestStatus.INCOMPLETE);
        }
        return statusesToRun;
    }
}

