/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.RunUtil;
import com.google.common.base.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AaptParser {
    private static final Pattern PKG_PATTERN = Pattern.compile("^package:\\s+name='(.*?)'\\s+versionCode='(\\d*)'\\s+versionName='(.*?)'.*$", 8);
    private static final Pattern LABEL_PATTERN = Pattern.compile("^application-label:'(.+?)'.*$", 8);
    private static final Pattern SDK_PATTERN = Pattern.compile("^sdkVersion:'(\\d+)'", 8);
    private static final Pattern TARGET_SDK_PATTERN = Pattern.compile("^targetSdkVersion:'(\\d+)'", 8);
    private static final int MAX_NUM_NATIVE_CODE = 10;
    private static final Pattern NATIVE_CODE_PATTERN = Pattern.compile("native-code: '(.*?)'" + Strings.repeat("( '.*?')?", 9));
    private static final Pattern REQUEST_LEGACY_STORAGE_PATTERN = Pattern.compile("requestLegacyExternalStorage.*=\\(.*\\)(.*)", 8);
    private static final Pattern ALT_NATIVE_CODE_PATTERN = Pattern.compile("alt-native-code: '(.*)'");
    private static final Pattern USES_PERMISSION_MANAGE_EXTERNAL_STORAGE_PATTERN = Pattern.compile("uses-permission: name='android\\.permission\\.MANAGE_EXTERNAL_STORAGE'");
    private static final int AAPT_TIMEOUT_MS = 60000;
    private static final int INVALID_SDK = -1;
    private String mPackageName;
    private String mVersionCode;
    private String mVersionName;
    private List<String> mNativeCode = new ArrayList<String>();
    private String mLabel;
    private int mSdkVersion = -1;
    private int mTargetSdkVersion = 10000;
    private boolean mRequestLegacyStorage = false;
    private boolean mUsesPermissionManageExternalStorage;

    AaptParser() {
    }

    boolean parse(String aaptOut) {
        Matcher m = PKG_PATTERN.matcher(aaptOut);
        if (m.find()) {
            int i;
            this.mLabel = this.mPackageName = m.group(1);
            this.mVersionCode = m.group(2);
            this.mVersionName = m.group(3);
            m = LABEL_PATTERN.matcher(aaptOut);
            if (m.find()) {
                this.mLabel = m.group(1);
            }
            if ((m = SDK_PATTERN.matcher(aaptOut)).find()) {
                this.mSdkVersion = Integer.parseInt(m.group(1));
            }
            if ((m = TARGET_SDK_PATTERN.matcher(aaptOut)).find()) {
                this.mTargetSdkVersion = Integer.parseInt(m.group(1));
            }
            if ((m = NATIVE_CODE_PATTERN.matcher(aaptOut)).find()) {
                for (i = 1; i <= m.groupCount(); ++i) {
                    if (m.group(i) == null) continue;
                    this.mNativeCode.add(m.group(i).replace("'", "").trim());
                }
            }
            if ((m = ALT_NATIVE_CODE_PATTERN.matcher(aaptOut)).find()) {
                for (i = 1; i <= m.groupCount(); ++i) {
                    if (m.group(i) == null) continue;
                    this.mNativeCode.add(m.group(i).replace("'", ""));
                }
            }
            m = USES_PERMISSION_MANAGE_EXTERNAL_STORAGE_PATTERN.matcher(aaptOut);
            this.mUsesPermissionManageExternalStorage = m.find();
            return true;
        }
        LogUtil.CLog.e("Failed to parse package and version info from 'aapt dump badging'. stdout: '%s'", aaptOut);
        return false;
    }

    public static AaptParser parse(File apkFile) {
        return AaptParser.parse(apkFile, AaptVersion.AAPT);
    }

    public static AaptParser parse(File apkFile, AaptVersion aaptVersion) {
        CommandResult result = RunUtil.getDefault().runTimedCmdRetry(60000L, 0L, 2, aaptVersion.dumpBadgingCommand(apkFile));
        String stderr = result.getStderr();
        if (stderr != null && !stderr.isEmpty()) {
            LogUtil.CLog.e("%s dump badging stderr: %s", AaptParser.toolName(aaptVersion), stderr);
        }
        AaptParser p = new AaptParser();
        if (!CommandStatus.SUCCESS.equals((Object)result.getStatus()) || !p.parse(result.getStdout())) {
            LogUtil.CLog.e("Failed to run %s on %s. stdout: %s", AaptParser.toolName(aaptVersion), apkFile.getAbsoluteFile(), result.getStdout());
            return null;
        }
        result = RunUtil.getDefault().runTimedCmdRetry(60000L, 0L, 2, aaptVersion.dumpXmlTreeCommand(apkFile));
        stderr = result.getStderr();
        if (stderr != null && !stderr.isEmpty()) {
            LogUtil.CLog.e("%s dump xmltree AndroidManifest.xml stderr: %s", AaptParser.toolName(aaptVersion), stderr);
        }
        if (!CommandStatus.SUCCESS.equals((Object)result.getStatus()) || !p.parseXmlTree(result.getStdout())) {
            LogUtil.CLog.e("Failed to run %s on %s. stdout: %s", AaptParser.toolName(aaptVersion), apkFile.getAbsoluteFile(), result.getStdout());
            return null;
        }
        return p;
    }

    boolean parseXmlTree(String aaptOut) {
        Matcher m = REQUEST_LEGACY_STORAGE_PATTERN.matcher(aaptOut);
        if (m.find()) {
            this.mRequestLegacyStorage = m.group(1).equals("0xffffffff");
        }
        return true;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public String getVersionCode() {
        return this.mVersionCode;
    }

    public String getVersionName() {
        return this.mVersionName;
    }

    public List<String> getNativeCode() {
        return this.mNativeCode;
    }

    public String getLabel() {
        return this.mLabel;
    }

    public int getSdkVersion() {
        return this.mSdkVersion;
    }

    public int getTargetSdkVersion() {
        return this.mTargetSdkVersion;
    }

    public boolean isRequestingLegacyStorage() {
        return this.mRequestLegacyStorage;
    }

    public boolean isUsingPermissionManageExternalStorage() {
        return this.mUsesPermissionManageExternalStorage;
    }

    private static String toolName(AaptVersion version) {
        return version.name().toLowerCase();
    }

    public static enum AaptVersion {
        AAPT{

            @Override
            public String[] dumpBadgingCommand(File apkFile) {
                return new String[]{"aapt", "dump", "badging", apkFile.getAbsolutePath()};
            }

            @Override
            public String[] dumpXmlTreeCommand(File apkFile) {
                return new String[]{"aapt", "dump", "xmltree", apkFile.getAbsolutePath(), "AndroidManifest.xml"};
            }
        }
        ,
        AAPT2{

            @Override
            public String[] dumpBadgingCommand(File apkFile) {
                return new String[]{"aapt2", "dump", "badging", apkFile.getAbsolutePath()};
            }

            @Override
            public String[] dumpXmlTreeCommand(File apkFile) {
                return new String[]{"aapt2", "dump", "xmltree", apkFile.getAbsolutePath(), "--file", "AndroidManifest.xml"};
            }
        };


        public abstract String[] dumpBadgingCommand(File var1);

        public abstract String[] dumpXmlTreeCommand(File var1);
    }
}

