/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AbiFormatter {
    private static final String PRODUCT_CPU_ABILIST_KEY = "ro.product.cpu.abilist";
    private static final String PRODUCT_CPU_ABI_KEY = "ro.product.cpu.abi";
    public static final String FORCE_ABI_STRING = "force-abi";
    public static final String FORCE_ABI_DESCRIPTION = "The abi to use, can be either 32 or 64.";
    static final String ABI_REGEX = "\\|#ABI(\\d*)#\\|";

    public static String formatCmdForAbi(String str, String abi) {
        if (str == null) {
            return null;
        }
        if (abi == null) {
            return str.replaceAll(ABI_REGEX, "");
        }
        StringBuffer sb = new StringBuffer();
        Matcher m = Pattern.compile(ABI_REGEX).matcher(str);
        while (m.find()) {
            if (m.group(1).equals(abi)) {
                m.appendReplacement(sb, "");
                continue;
            }
            m.appendReplacement(sb, abi);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String getDefaultAbi(ITestDevice device, String bitness) throws DeviceNotAvailableException {
        String[] abis = AbiFormatter.getSupportedAbis(device, bitness);
        if (abis != null && abis.length > 0 && abis[0] != null && abis[0].length() > 0) {
            return abis[0];
        }
        return null;
    }

    public static String[] getSupportedAbis(ITestDevice device, String bitness) throws DeviceNotAvailableException {
        String[] abis;
        String abiList = device.getProperty(PRODUCT_CPU_ABILIST_KEY + bitness);
        if (abiList != null && !abiList.isEmpty() && (abis = abiList.split(",")).length > 0) {
            return abis;
        }
        String legacyProperty = device.getProperty(PRODUCT_CPU_ABI_KEY);
        if (legacyProperty != null) {
            return new String[]{legacyProperty};
        }
        return new String[0];
    }
}

