/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.RunUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class AbiUtils {
    public static final String ABI_ARM_V7A = "armeabi-v7a";
    public static final String ABI_ARM_64_V8A = "arm64-v8a";
    public static final String ABI_X86 = "x86";
    public static final String ABI_X86_64 = "x86_64";
    public static final String ABI_MIPS = "mips";
    public static final String ABI_MIPS64 = "mips64";
    public static final String ABI_RISCV64 = "riscv64";
    public static final String BASE_ARCH_ARM = "arm";
    public static final String ARCH_ARM64 = "arm64";
    public static final String BASE_ARCH_X86 = "x86";
    public static final String ARCH_X86_64 = "x86_64";
    public static final String BASE_ARCH_MIPS = "mips";
    public static final String ARCH_MIPS64 = "mips64";
    public static final String ARCH_RISCV64 = "riscv64";
    private static final Set<String> ABIS_32BIT = new LinkedHashSet<String>();
    private static final Set<String> ABIS_64BIT = new LinkedHashSet<String>();
    protected static final Set<String> ARM_ABIS = new LinkedHashSet<String>();
    private static final Set<String> INTEL_ABIS = new LinkedHashSet<String>();
    private static final Set<String> MIPS_ABIS = new LinkedHashSet<String>();
    private static final Set<String> RISCV_ABIS = new LinkedHashSet<String>();
    protected static final Set<String> ABIS_SUPPORTED_BY_COMPATIBILITY = new LinkedHashSet<String>();
    private static final Set<String> ARCH_SUPPORTED = new LinkedHashSet<String>();
    private static final Map<String, Set<String>> ARCH_TO_ABIS = new LinkedHashMap<String, Set<String>>();
    private static final Map<String, String> ABI_TO_ARCH = new LinkedHashMap<String, String>();
    private static final Map<String, String> ABI_TO_BASE_ARCH = new LinkedHashMap<String, String>();

    private AbiUtils() {
    }

    public static Set<String> getAbisForArch(String arch) {
        if (arch == null || arch.isEmpty() || !ARCH_TO_ABIS.containsKey(arch)) {
            return AbiUtils.getAbisSupportedByCompatibility();
        }
        return new LinkedHashSet<String>((Collection)ARCH_TO_ABIS.get(arch));
    }

    public static String getArchForAbi(String abi) {
        if (abi == null || abi.isEmpty()) {
            throw new IllegalArgumentException("Abi cannot be null or empty");
        }
        return ABI_TO_ARCH.get(abi);
    }

    public static String getBaseArchForAbi(String abi) {
        if (abi == null || abi.isEmpty()) {
            throw new IllegalArgumentException("Abi cannot be null or empty");
        }
        return ABI_TO_BASE_ARCH.get(abi);
    }

    public static Set<String> getAbisSupportedByCompatibility() {
        return new LinkedHashSet<String>(ABIS_SUPPORTED_BY_COMPATIBILITY);
    }

    public static Set<String> getArchSupported() {
        return new LinkedHashSet<String>(ARCH_SUPPORTED);
    }

    public static boolean isAbiSupportedByCompatibility(String abi) {
        return ABIS_SUPPORTED_BY_COMPATIBILITY.contains(abi);
    }

    public static String createAbiFlag(String abi) {
        if (abi == null || abi.isEmpty() || !AbiUtils.isAbiSupportedByCompatibility(abi)) {
            return "";
        }
        return String.format("--abi %s ", abi);
    }

    public static String createId(String abi, String name) {
        return String.format("%s %s", abi, name);
    }

    public static String[] parseId(String id) {
        if (id == null || !id.contains(" ")) {
            return new String[]{"", ""};
        }
        return id.split(" ");
    }

    public static String parseTestName(String id) {
        return AbiUtils.parseId(id)[1];
    }

    public static String parseAbi(String id) {
        return AbiUtils.parseId(id)[0];
    }

    public static String getBitness(String abi) {
        return ABIS_32BIT.contains(abi) ? "32" : "64";
    }

    public static Set<String> parseAbiList(String unsupportedAbiDescription) {
        HashSet<String> abiSet = new HashSet<String>();
        String[] descSegments = unsupportedAbiDescription.split(":");
        if (descSegments.length == 2) {
            for (String abi : descSegments[1].split(",")) {
                String trimmedAbi = abi.trim();
                if (!AbiUtils.isAbiSupportedByCompatibility(trimmedAbi)) continue;
                abiSet.add(trimmedAbi);
            }
        }
        return abiSet;
    }

    public static Set<String> parseAbiListFromProperty(String abiListProp) {
        String[] abiList;
        HashSet<String> abiSet = new HashSet<String>();
        if (abiListProp == null) {
            return abiSet;
        }
        for (String abi : abiList = abiListProp.split(",")) {
            String trimmedAbi = abi.trim();
            if (!AbiUtils.isAbiSupportedByCompatibility(trimmedAbi)) continue;
            abiSet.add(trimmedAbi);
        }
        return abiSet;
    }

    public static Set<String> getHostAbi() {
        CommandResult commandResult = RunUtil.getDefault().runTimedCmd(5000L, "uname", "-m");
        String mainAbi = commandResult.getStdout().trim();
        return AbiUtils.getAbisForArch(mainAbi);
    }

    static {
        ABIS_32BIT.add(ABI_ARM_V7A);
        ABIS_32BIT.add("x86");
        ABIS_32BIT.add("mips");
        ABIS_64BIT.add(ABI_ARM_64_V8A);
        ABIS_64BIT.add("x86_64");
        ABIS_64BIT.add("mips64");
        ABIS_64BIT.add("riscv64");
        ARM_ABIS.add(ABI_ARM_64_V8A);
        ARM_ABIS.add(ABI_ARM_V7A);
        INTEL_ABIS.add("x86_64");
        INTEL_ABIS.add("x86");
        MIPS_ABIS.add("mips64");
        MIPS_ABIS.add("mips");
        RISCV_ABIS.add("riscv64");
        ARCH_TO_ABIS.put(BASE_ARCH_ARM, ARM_ABIS);
        ARCH_TO_ABIS.put(ARCH_ARM64, ARM_ABIS);
        ARCH_TO_ABIS.put("x86", INTEL_ABIS);
        ARCH_TO_ABIS.put("x86_64", INTEL_ABIS);
        ARCH_TO_ABIS.put("mips", MIPS_ABIS);
        ARCH_TO_ABIS.put("mips64", MIPS_ABIS);
        ARCH_TO_ABIS.put("riscv64", RISCV_ABIS);
        ABIS_SUPPORTED_BY_COMPATIBILITY.addAll(ARM_ABIS);
        ABIS_SUPPORTED_BY_COMPATIBILITY.addAll(INTEL_ABIS);
        ABIS_SUPPORTED_BY_COMPATIBILITY.addAll(MIPS_ABIS);
        ABIS_SUPPORTED_BY_COMPATIBILITY.addAll(RISCV_ABIS);
        ABI_TO_ARCH.put(ABI_ARM_V7A, BASE_ARCH_ARM);
        ABI_TO_ARCH.put(ABI_ARM_64_V8A, ARCH_ARM64);
        ABI_TO_ARCH.put("x86", "x86");
        ABI_TO_ARCH.put("x86_64", "x86_64");
        ABI_TO_ARCH.put("mips", "mips");
        ABI_TO_ARCH.put("mips64", "mips64");
        ABI_TO_ARCH.put("riscv64", "riscv64");
        ABI_TO_BASE_ARCH.put(ABI_ARM_V7A, BASE_ARCH_ARM);
        ABI_TO_BASE_ARCH.put(ABI_ARM_64_V8A, BASE_ARCH_ARM);
        ABI_TO_BASE_ARCH.put("x86", "x86");
        ABI_TO_BASE_ARCH.put("x86_64", "x86");
        ABI_TO_BASE_ARCH.put("mips", "mips");
        ABI_TO_BASE_ARCH.put("mips64", "mips");
        ABI_TO_BASE_ARCH.put("riscv64", "riscv64");
        ARCH_SUPPORTED.add(BASE_ARCH_ARM);
        ARCH_SUPPORTED.add(ARCH_ARM64);
        ARCH_SUPPORTED.add("x86");
        ARCH_SUPPORTED.add("x86_64");
        ARCH_SUPPORTED.add("mips");
        ARCH_SUPPORTED.add("mips64");
        ARCH_SUPPORTED.add("riscv64");
    }
}

