/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.INativeDevice;

public class AdbRootElevator
implements AutoCloseable {
    private final boolean mWasRoot;
    private final INativeDevice mDevice;

    public AdbRootElevator(INativeDevice device) throws DeviceNotAvailableException {
        this.mDevice = device;
        this.mWasRoot = this.mDevice.isAdbRoot();
        if (!this.mWasRoot && !this.mDevice.enableAdbRoot()) {
            throw new RuntimeException("Failed to enable adb root.");
        }
    }

    @Override
    public void close() {
        if (!this.mWasRoot) {
            try {
                this.mDevice.disableAdbRoot();
            }
            catch (DeviceNotAvailableException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

