/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.invoker.ExecutionFiles;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.IRunUtil;
import java.io.File;

public class AdbUtils {
    private static final String PATH_VAR = "PATH";
    private static final long PATH_TIMEOUT_MS = 60000L;

    public static void updateAdb(TestInformation testInfo, IRunUtil runUtil, String adbPath) {
        File updatedAdb = testInfo.executionFiles().get(ExecutionFiles.FilesKey.ADB_BINARY);
        if (updatedAdb == null) {
            if (!adbPath.equals("adb")) {
                updatedAdb = new File(adbPath);
                if (!updatedAdb.exists()) {
                    LogUtil.CLog.w(String.format("adb path %s doesn't exist. Fall back on the abd in $PATH", adbPath));
                    updatedAdb = null;
                }
            } else {
                LogUtil.CLog.d("Use the adb in the $PATH.");
            }
        }
        if (updatedAdb == null) {
            return;
        }
        LogUtil.CLog.d("Testing with adb binary at: %s", updatedAdb);
        CommandResult pathResult = runUtil.runTimedCmd(60000L, "/bin/bash", "-c", "echo $PATH");
        if (!CommandStatus.SUCCESS.equals((Object)pathResult.getStatus())) {
            throw new RuntimeException(String.format("Failed to get the $PATH. status: %s, stdout: %s, stderr: %s", new Object[]{pathResult.getStatus(), pathResult.getStdout(), pathResult.getStderr()}));
        }
        String path = String.format("%s:%s", updatedAdb.getParentFile().getAbsolutePath(), pathResult.getStdout().trim());
        LogUtil.CLog.d("Using $PATH with updated adb: %s", path);
        runUtil.setEnvVariable(PATH_VAR, path);
        CommandResult versionRes = runUtil.runTimedCmd(60000L, "adb", "version");
        LogUtil.CLog.d("%s", versionRes.getStdout());
        LogUtil.CLog.d("%s", versionRes.getStderr());
    }
}

