/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class AppVersionFetcher {
    private static final String DUMP_PACKAGE_COMMAND = "dumpsys package";
    private static final Pattern VERSION_CODE_PATTERN = Pattern.compile("\\s+versionCode=(\\d+) .*");
    private static final Pattern VERSION_NAME_PATTERN = Pattern.compile("\\s+versionName=(.*?)");

    public static String fetch(ITestDevice device, String packageName, AppVersionInfo info) throws DeviceNotAvailableException {
        switch (info) {
            case VERSION_CODE: {
                return AppVersionFetcher.fetchVersionCode(device, packageName);
            }
            case VERSION_NAME: {
                return AppVersionFetcher.fetchVersionName(device, packageName);
            }
        }
        throw new IllegalArgumentException("Unknown app version info");
    }

    private static String fetchVersionName(ITestDevice device, String packageName) throws DeviceNotAvailableException {
        String shellCommand = String.format("%s %s | grep versionName=", DUMP_PACKAGE_COMMAND, packageName);
        String packageInfo = device.executeShellCommand(shellCommand);
        return AppVersionFetcher.parseVersionString(packageInfo, VERSION_NAME_PATTERN);
    }

    private static String fetchVersionCode(ITestDevice device, String packageName) throws DeviceNotAvailableException {
        String shellCommand = String.format("%s %s | grep versionCode=", DUMP_PACKAGE_COMMAND, packageName);
        String packageInfo = device.executeShellCommand(shellCommand);
        return AppVersionFetcher.parseVersionString(packageInfo, VERSION_CODE_PATTERN);
    }

    private static String parseVersionString(String packageInfo, Pattern pattern) {
        Matcher matcher;
        if (packageInfo == null) {
            throw new IllegalArgumentException("Shell command result is null");
        }
        Object[] lines = packageInfo.split("\\r?\\n");
        if (lines.length > 1) {
            LogUtil.CLog.i("There are two versions:\n%s\nThe first one is picked.", Arrays.toString(lines));
        }
        if (!(matcher = pattern.matcher(lines[0])).matches()) {
            throw new IllegalStateException("Invalid app version string: " + (String)lines[0]);
        }
        return matcher.group(1);
    }

    public static enum AppVersionInfo {
        VERSION_CODE,
        VERSION_NAME;

    }
}

