/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.device.CollectingOutputReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.sl4a.Sl4aClient;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BluetoothUtils {
    private static final String BT_INSTR_CMD = "am instrument -w -r -e command %s com.android.bluetooth.tests/android.bluetooth.BluetoothInstrumentation";
    private static final String SUCCESS_INSTR_OUTPUT = "INSTRUMENTATION_RESULT: result=SUCCESS";
    private static final String BT_GETADDR_HEADER = "INSTRUMENTATION_RESULT: address=";
    private static final long BASE_RETRY_DELAY_MS = 60000L;
    private static final int MAX_RETRIES = 3;
    private static final Pattern BONDED_MAC_HEADER = Pattern.compile("INSTRUMENTATION_RESULT: device-\\d{2}=(.*)$");
    private static final String BT_STACK_CONF = "/etc/bluetooth/bt_stack.conf";
    public static final String BTSNOOP_API = "bluetoothConfigHciSnoopLog";
    public static final String BTSNOOP_CMD = "setprop persist.bluetooth.btsnoopenable ";
    public static final String BTSNOOP_ENABLE_CMD = "setprop persist.bluetooth.btsnoopenable true";
    public static final String BTSNOOP_DISABLE_CMD = "setprop persist.bluetooth.btsnoopenable false";
    public static final String GOLD_BTSNOOP_LOG_PATH = "/data/misc/bluetooth/logs/btsnoop_hci.log";
    public static final String O_BUILD = "O";

    public static String runBluetoothInstrumentation(ITestDevice device, String command) throws DeviceNotAvailableException {
        CollectingOutputReceiver receiver = new CollectingOutputReceiver();
        device.executeShellCommand(String.format(BT_INSTR_CMD, command), receiver);
        String output = receiver.getOutput();
        LogUtil.CLog.v("bluetooth instrumentation sub command: %s\noutput:\n", command);
        LogUtil.CLog.v(output);
        return output;
    }

    public static boolean runBluetoothInstrumentationWithRetry(ITestDevice device, String command) throws DeviceNotAvailableException {
        for (int retry = 0; retry < 3; ++retry) {
            String output = BluetoothUtils.runBluetoothInstrumentation(device, command);
            if (output.contains(SUCCESS_INSTR_OUTPUT)) {
                return true;
            }
            RunUtil.getDefault().sleep((long)retry * 60000L);
        }
        return false;
    }

    public static boolean unpairWithRetry(ITestDevice device) throws DeviceNotAvailableException {
        return BluetoothUtils.runBluetoothInstrumentationWithRetry(device, "unpairAll");
    }

    public static String getBluetoothMac(ITestDevice device) throws DeviceNotAvailableException {
        String[] lines;
        for (String line : lines = BluetoothUtils.runBluetoothInstrumentation(device, "getAddress").split("\\r?\\n")) {
            if (!(line = line.trim()).startsWith(BT_GETADDR_HEADER)) continue;
            return line.substring(BT_GETADDR_HEADER.length());
        }
        return null;
    }

    public static boolean enable(ITestDevice device) throws DeviceNotAvailableException {
        return BluetoothUtils.runBluetoothInstrumentationWithRetry(device, "enable");
    }

    public static boolean disable(ITestDevice device) throws DeviceNotAvailableException {
        return BluetoothUtils.runBluetoothInstrumentationWithRetry(device, "disable");
    }

    public static Set<String> getBondedDevices(ITestDevice device) throws DeviceNotAvailableException {
        String[] lines = BluetoothUtils.runBluetoothInstrumentation(device, "getBondedDevices").split("\\r?\\n");
        return BluetoothUtils.parseBondedDeviceInstrumentationOutput(lines);
    }

    static Set<String> parseBondedDeviceInstrumentationOutput(String[] lines) {
        HashSet<String> ret = new HashSet<String>();
        for (String line : lines) {
            Matcher m = BONDED_MAC_HEADER.matcher(line.trim());
            if (!m.find()) continue;
            ret.add(m.group(1));
        }
        return ret;
    }

    private static boolean isGoldAndAbove(ITestDevice device) throws DeviceNotAvailableException {
        int apiLevel = device.getApiLevel();
        if (!"REL".equals(device.getProperty("ro.build.version.codename"))) {
            ++apiLevel;
        }
        return apiLevel >= 25;
    }

    public static boolean enableBtsnoopLogging(ITestDevice device) throws DeviceNotAvailableException {
        if (BluetoothUtils.isGoldAndAbove(device)) {
            device.executeShellCommand(BTSNOOP_ENABLE_CMD);
            BluetoothUtils.disable(device);
            BluetoothUtils.enable(device);
            return true;
        }
        return BluetoothUtils.enableBtsnoopLogging(device, null);
    }

    public static boolean enableBtsnoopLogging(ITestDevice device, File sl4aApkFile) throws DeviceNotAvailableException {
        Sl4aClient client = new Sl4aClient(device, sl4aApkFile);
        return BluetoothUtils.toggleBtsnoopLogging(client, true);
    }

    public static boolean disableBtsnoopLogging(ITestDevice device) throws DeviceNotAvailableException {
        if (BluetoothUtils.isGoldAndAbove(device)) {
            device.executeShellCommand(BTSNOOP_DISABLE_CMD);
            BluetoothUtils.disable(device);
            BluetoothUtils.enable(device);
            return true;
        }
        return BluetoothUtils.disableBtsnoopLogging(device, null);
    }

    public static boolean disableBtsnoopLogging(ITestDevice device, File sl4aApkFile) throws DeviceNotAvailableException {
        Sl4aClient client = new Sl4aClient(device, sl4aApkFile);
        return BluetoothUtils.toggleBtsnoopLogging(client, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean toggleBtsnoopLogging(Sl4aClient client, boolean onOff) throws DeviceNotAvailableException {
        try {
            client.startSl4A();
            client.rpcCall(BTSNOOP_API, onOff);
            boolean bl = true;
            return bl;
        }
        catch (IOException | RuntimeException e) {
            LogUtil.CLog.e(e);
            boolean bl = false;
            return bl;
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void uploadLogFiles(ITestInvocationListener listener, ITestDevice device, String type, int iteration) throws DeviceNotAvailableException {
        File logFile = null;
        FileInputStreamSource logSource = null;
        String fileName = BluetoothUtils.getBtSnoopLogFilePath(device);
        if (fileName == null) return;
        try {
            logFile = device.pullFile(fileName);
            if (logFile == null) return;
            LogUtil.CLog.d("Sending %s %d byte file %s into the logosphere!", type, logFile.length(), logFile);
            logSource = new FileInputStreamSource(logFile);
            listener.testLog(String.format("%s_btsnoop_%d", type, iteration), LogDataType.UNKNOWN, logSource);
            return;
        }
        finally {
            FileUtil.deleteFile(logFile);
            StreamUtil.cancel(logSource);
        }
    }

    public static void cleanLogFile(ITestDevice device) throws DeviceNotAvailableException {
        String fileName = BluetoothUtils.getBtSnoopLogFilePath(device);
        if (fileName != null) {
            device.executeShellCommand(String.format("rm %s", fileName));
        } else {
            LogUtil.CLog.e("Not able to delete BT snoop log, file not found");
        }
    }

    public static String getBtSnoopLogFilePath(ITestDevice device) throws DeviceNotAvailableException {
        if (BluetoothUtils.isGoldAndAbove(device)) {
            return GOLD_BTSNOOP_LOG_PATH;
        }
        String snoopfileSetting = device.executeShellCommand(String.format("cat %s | grep BtSnoopFileName", BT_STACK_CONF));
        String[] settingItems = snoopfileSetting.split("=");
        if (settingItems.length > 1) {
            return settingItems[1].trim();
        }
        LogUtil.CLog.e(String.format("Not able to local BT snoop log, '%s'", snoopfileSetting));
        return null;
    }
}

