/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.ZipUtil2;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class Bugreport
implements Closeable {
    private File mBugreport;
    private boolean mIsZipped;

    public Bugreport(File bugreportFile, boolean isZipped) {
        this.mBugreport = bugreportFile;
        this.mIsZipped = isZipped;
    }

    public boolean isZipped() {
        return this.mIsZipped;
    }

    public void log(String dataName, ITestLogger logger) {
        LogDataType type = this.isZipped() ? LogDataType.BUGREPORTZ : LogDataType.BUGREPORT;
        try (FileInputStreamSource source = new FileInputStreamSource(this.mBugreport);){
            logger.testLog(dataName, type, source);
        }
    }

    /*
     * Exception decompiling
     */
    public File getMainFile() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<String> getListOfFiles() {
        if (this.mBugreport == null) {
            return null;
        }
        ArrayList<String> list2 = new ArrayList<String>();
        if (!this.mIsZipped) {
            return null;
        }
        try (ZipFile zipBugreport = new ZipFile(this.mBugreport);){
            for (ZipArchiveEntry entry : Collections.list(zipBugreport.getEntries())) {
                list2.add(entry.getName());
            }
        }
        catch (IOException e) {
            LogUtil.CLog.e("Error reading the list of files in the bugreport");
            LogUtil.CLog.e(e);
        }
        return list2;
    }

    public File getFileByName(String name) {
        if (this.mBugreport == null || name == null) {
            return null;
        }
        if (this.mIsZipped) {
            return this.extractFileBugreport(name);
        }
        return null;
    }

    private File extractFileBugreport(String name) {
        File file2;
        File bugreport = null;
        ZipFile zip = new ZipFile(this.mBugreport);
        try {
            file2 = bugreport = ZipUtil2.extractFileFromZip(zip, name);
        }
        catch (Throwable throwable) {
            try {
                try {
                    zip.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LogUtil.CLog.e("Error while unzipping bugreportz");
                LogUtil.CLog.e(e);
                return null;
            }
        }
        zip.close();
        return file2;
    }

    @Override
    public void close() throws IOException {
        FileUtil.deleteFile(this.mBugreport);
    }
}

