/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.targetprep.AltDirBehavior;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class BuildTestsZipUtils {
    public static File getApkFile(IBuildInfo buildInfo, String apkFileName, List<File> altDirs, AltDirBehavior altDirBehavior, boolean lookupInResource, String deviceSigningKey) throws IOException {
        File apkFile;
        String apkBase = apkFileName.split("\\.")[0];
        ArrayList<File> dirs = new ArrayList<File>();
        if (altDirs != null) {
            for (File dir : altDirs) {
                dirs.add(dir);
                dirs.add(FileUtil.getFileForPath(dir, "DATA", "app"));
                dirs.add(FileUtil.getFileForPath(dir, "DATA", "app", apkBase));
                dirs.add(FileUtil.getFileForPath(dir, "DATA", "priv-app", apkBase));
                dirs.add(FileUtil.getFileForPath(dir, "data", "app", apkBase));
            }
        }
        Collections.reverse(dirs);
        ArrayList<Object> expandedTestDirs = new ArrayList<Object>();
        File testsDir = null;
        if (buildInfo != null && buildInfo instanceof IDeviceBuildInfo && (testsDir = ((IDeviceBuildInfo)buildInfo).getTestsDir()) != null && testsDir.exists()) {
            expandedTestDirs.add(FileUtil.getFileForPath(testsDir, "DATA", "app"));
            expandedTestDirs.add(FileUtil.getFileForPath(testsDir, "DATA", "app", apkBase));
            expandedTestDirs.add(FileUtil.getFileForPath(testsDir, "DATA", "priv-app", apkBase));
            expandedTestDirs.add(FileUtil.getFileForPath(testsDir, apkBase));
            File testcasesSubDir = FileUtil.findFile(testsDir, apkBase);
            if (testcasesSubDir != null) {
                expandedTestDirs.add(testcasesSubDir);
            } else {
                expandedTestDirs.add(testsDir);
            }
        }
        if (altDirBehavior == null) {
            altDirBehavior = AltDirBehavior.FALLBACK;
        }
        if (altDirBehavior == AltDirBehavior.FALLBACK) {
            expandedTestDirs.addAll(dirs);
            dirs = expandedTestDirs;
        } else if (altDirBehavior == AltDirBehavior.OVERRIDE) {
            dirs.addAll(expandedTestDirs);
        } else {
            throw new IOException("Missing handler for alt-dir-behavior: " + (Object)((Object)altDirBehavior));
        }
        if (dirs.isEmpty() && !lookupInResource) {
            throw new IOException("Provided buildInfo does not contain a valid tests directory and no fallback options were provided");
        }
        for (File dir : dirs) {
            File testAppFile = FileUtil.findFile(dir, apkFileName);
            if (testAppFile == null || !testAppFile.exists()) continue;
            return testAppFile;
        }
        if (lookupInResource) {
            String path;
            ArrayList<String> resourceLookup = new ArrayList<String>();
            if (deviceSigningKey != null) {
                resourceLookup.add(String.format("/apks/%s-%s.apk", apkBase, deviceSigningKey));
            }
            resourceLookup.add(String.format("/apks/%s", apkFileName));
            File apkTempFile = FileUtil.createTempFile(apkFileName, ".apk");
            URL apkUrl = null;
            Iterator iterator2 = resourceLookup.iterator();
            while (iterator2.hasNext() && (apkUrl = BuildTestsZipUtils.class.getResource(path = (String)iterator2.next())) == null) {
            }
            if (apkUrl != null) {
                FileUtil.writeToFile(apkUrl.openStream(), apkTempFile);
                apkTempFile.deleteOnExit();
                return apkTempFile;
            }
            FileUtil.deleteFile(apkTempFile);
        }
        if (testsDir != null && (apkFile = buildInfo.stageRemoteFile(apkFileName, testsDir)) != null) {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.STAGE_UNDEFINED_DEPENDENCY, apkFileName);
            return apkFile;
        }
        return null;
    }
}

