/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BundletoolUtil {
    private static final String GET_DEVICE_SPEC_OPTION = "get-device-spec";
    private static final String SPLITS_KEYWORD = "Splits";
    private static final String OUTPUT_DIR_FLAG = "--output-dir=";
    private static final String DEVICE_SPEC_OUTPUT_FLAG = "--output=";
    private static final String APKS_TO_EXTRACT_FLAG = "--apks=";
    private static final String DEVICE_SPEC_FLAG = "--device-spec=";
    private static final String DEVICE_ID_FLAG = "--device-id=";
    private static final String EXTRACT_APKS_OPTION = "extract-apks";
    private static final String INSTALL_APKS_OPTION = "install-apks";
    private static final String INSTALL_MULTI_APKS_OPTION = "install-multi-apks";
    private static final String DEVICE_SPEC_FILE_EXTENSION = ".json";
    private static final String APKS_FILE_INPUT_SELECTOR = "--apks=";
    private static final String ZIP_FILE_INPUT_SELECTOR = "--apks-zip=";
    private static final String TIMEOUT_MILLIS_FLAG = "--timeout-millis=";
    private static final long CMD_TIME_OUT = 120000L;
    private File mBundleToolFile;
    private IRunUtil mRunUtil;

    public BundletoolUtil(File bundletoolJar) {
        this.mBundleToolFile = bundletoolJar;
        this.mRunUtil = new RunUtil();
    }

    protected File getBundletoolFile() {
        return this.mBundleToolFile;
    }

    public String generateDeviceSpecFile(ITestDevice device) throws IOException {
        CommandResult res;
        Path specFilePath = Paths.get(this.getBundletoolFile().getParentFile().getAbsolutePath(), device.getSerialNumber() + DEVICE_SPEC_FILE_EXTENSION);
        Files.deleteIfExists(specFilePath);
        String outputDirArg = DEVICE_SPEC_OUTPUT_FLAG + specFilePath.toString();
        String deviceIdArg = DEVICE_ID_FLAG + device.getSerialNumber();
        ArrayList<String> generateDeviceSpecCmd = new ArrayList<String>(Arrays.asList("java", "-jar", this.getBundletoolFile().getAbsolutePath(), GET_DEVICE_SPEC_OPTION, outputDirArg, deviceIdArg));
        if (this.getAdbPath() != null) {
            generateDeviceSpecCmd.add("--adb=" + this.getAdbPath());
        }
        if (!CommandStatus.SUCCESS.equals((Object)(res = this.getRunUtil().runTimedCmd(120000L, generateDeviceSpecCmd.toArray(new String[generateDeviceSpecCmd.size()]))).getStatus())) {
            LogUtil.CLog.e("Failed to generated device spec file. Cmd is %s. CommandStatus: %s. Error: %s.", new Object[]{((Object)generateDeviceSpecCmd).toString(), res.getStatus(), res.getStderr()});
            return null;
        }
        return specFilePath.toString();
    }

    public File extractSplitsFromApks(File apks, String deviceSpecPath, ITestDevice device, IBuildInfo buildInfo) {
        String destDirPath = apks.getParentFile().getAbsolutePath();
        String[] helperArray = apks.getName().split("\\.");
        String moduleName = helperArray[helperArray.length - 2];
        File destDir = new File(destDirPath, moduleName + SPLITS_KEYWORD);
        destDir.mkdir();
        String outputPathArg = OUTPUT_DIR_FLAG + destDir.getAbsolutePath();
        String inputPathArg = "--apks=" + apks.getAbsolutePath();
        String deviceSpecArg = DEVICE_SPEC_FLAG + deviceSpecPath;
        Object[] extractApkCmd = new String[]{"java", "-jar", this.getBundletoolFile().getAbsolutePath(), EXTRACT_APKS_OPTION, inputPathArg, outputPathArg, deviceSpecArg};
        CommandResult res = this.getRunUtil().runTimedCmd(120000L, (String[])extractApkCmd);
        if (!CommandStatus.SUCCESS.equals((Object)res.getStatus())) {
            FileUtil.recursiveDelete(destDir);
            LogUtil.CLog.e("Failed to extract split apk. Cmd: %s. Error: %s.", Arrays.toString(extractApkCmd), res.getStderr());
            return null;
        }
        return destDir;
    }

    private void installApksOnDevice(File inputFile, ITestDevice device, String inputArg, String installOptionCmd, List<String> extraArgs, String onErrorMsg, String onSuccessMsg) throws TargetSetupError {
        CommandResult res;
        String inputPathArg = inputArg + inputFile.getAbsolutePath();
        String deviceIdArg = DEVICE_ID_FLAG + device.getSerialNumber();
        ArrayList<String> installApksCmd = new ArrayList<String>(Arrays.asList("java", "-jar", this.getBundletoolFile().getAbsolutePath(), installOptionCmd, inputPathArg, deviceIdArg));
        installApksCmd.addAll(extraArgs);
        long cmdTimeout = BundletoolUtil.parseCmdTimeout(extraArgs, 120000L);
        if (this.getAdbPath() != null) {
            installApksCmd.add("--adb=" + this.getAdbPath());
        }
        if (!CommandStatus.SUCCESS.equals((Object)(res = this.getRunUtil().runTimedCmd(cmdTimeout, installApksCmd.toArray(new String[installApksCmd.size()]))).getStatus())) {
            throw new TargetSetupError(String.format("%s Cmd: %s. CommandStatus:%s. Error: %s.", new Object[]{onErrorMsg, installApksCmd, res.getStatus(), res.getStderr()}), device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.APK_INSTALLATION_FAILED);
        }
        LogUtil.CLog.i(onSuccessMsg);
    }

    public void installApks(File apks, ITestDevice device) throws TargetSetupError {
        this.installApks(apks, device, new ArrayList<String>());
    }

    public void installApks(File apks, ITestDevice device, List<String> extraArgs) throws TargetSetupError {
        this.installApksOnDevice(apks, device, "--apks=", INSTALL_APKS_OPTION, extraArgs, "Failed to install split apks.", apks.getName() + " is installed successfully");
    }

    public void installApksFromZip(File apksZip, ITestDevice device, List<String> extraArgs) throws TargetSetupError {
        this.installApksOnDevice(apksZip, device, ZIP_FILE_INPUT_SELECTOR, INSTALL_MULTI_APKS_OPTION, extraArgs, "Failed to install apks from zip file", "Successfully installed apks from " + apksZip.getName());
    }

    @VisibleForTesting
    protected IRunUtil getRunUtil() {
        return this.mRunUtil;
    }

    @VisibleForTesting
    protected String getAdbPath() {
        String adbPath = GlobalConfiguration.getDeviceManagerInstance().getAdbPath();
        if (!new File(adbPath).exists()) {
            return null;
        }
        return adbPath;
    }

    @VisibleForTesting
    protected static long parseCmdTimeout(List<String> args, long defaultValue) throws TargetSetupError {
        for (int i = 0; i < args.size(); ++i) {
            if (!args.get(i).startsWith(TIMEOUT_MILLIS_FLAG)) continue;
            String value = args.get(i).substring(TIMEOUT_MILLIS_FLAG.length());
            try {
                long timeout = Long.parseLong(value);
                return Long.max(timeout, defaultValue);
            }
            catch (NumberFormatException e) {
                throw new TargetSetupError(String.format("Invalid parameter for --timeout-millis=%s. It should be a numeric value", value), (Throwable)e, (ErrorIdentifier)InfraErrorIdentifier.INTERNAL_CONFIG_ERROR);
            }
        }
        return defaultValue;
    }
}

