/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import java.util.Arrays;

public class ByteArrayList {
    private byte[] mStorage = new byte[this.mMaxBytes];
    private int mMaxBytes = 128;
    private int mCurBytes = 0;
    private float mGrowthFactor = 2.0f;

    public ByteArrayList() {
    }

    public ByteArrayList(int defaultSize) {
        this();
        this.setSize(defaultSize);
    }

    public ByteArrayList(int defaultSize, float growthFactor) {
        this(defaultSize);
        if (growthFactor < 1.1f) {
            throw new IllegalArgumentException("Growth factor must be at least 1.1");
        }
        this.mGrowthFactor = growthFactor;
    }

    public void trimToSize() {
        this.setSize(this.size());
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new IllegalArgumentException("Minimum capacity must be non-negative");
        }
        if (minCapacity <= this.mMaxBytes) {
            return;
        }
        int curSize = this.mMaxBytes;
        if (curSize == 0) {
            curSize = 1;
        }
        int growthFactorMultiples = (int)Math.ceil((float)minCapacity / this.mGrowthFactor / (float)curSize);
        float newSize = (float)curSize * this.mGrowthFactor * (float)growthFactorMultiples;
        this.setSize((int)Math.ceil(newSize));
    }

    void setSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("New size must be non-negative");
        }
        if (size < this.mCurBytes) {
            this.mCurBytes = size;
        }
        this.mMaxBytes = size;
        byte[] newStorage = new byte[size];
        System.arraycopy(this.mStorage, 0, newStorage, 0, this.mCurBytes);
        this.mStorage = newStorage;
    }

    public byte[] getContents() {
        byte[] contents = new byte[this.mCurBytes];
        System.arraycopy(this.mStorage, 0, contents, 0, this.mCurBytes);
        return contents;
    }

    public boolean add(byte b) {
        this.ensureCapacity(this.mCurBytes + 1);
        this.mStorage[this.mCurBytes] = b;
        ++this.mCurBytes;
        return true;
    }

    public boolean addAll(byte[] src) {
        if (src == null) {
            throw new NullPointerException();
        }
        return this.addAll(src, 0, src.length);
    }

    public boolean addAll(byte[] src, int srcOffset, int length) {
        if (src == null) {
            throw new NullPointerException();
        }
        this.ensureCapacity(this.mCurBytes + length);
        System.arraycopy(src, srcOffset, this.mStorage, this.mCurBytes, length);
        this.mCurBytes += length;
        return true;
    }

    public boolean addall(ByteArrayList src) {
        if (src == null) {
            throw new NullPointerException();
        }
        return this.addAll(src.getContents());
    }

    public void clear() {
        this.mCurBytes = 0;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ByteArrayList)) {
            return false;
        }
        ByteArrayList otherList = (ByteArrayList)other;
        if (otherList.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (otherList.get(i) == this.get(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Arrays.hashCode(this.mStorage);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public byte get(int idx) {
        if (idx < 0 || idx >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.mStorage[idx];
    }

    public byte set(int idx, byte b) {
        if (idx < 0 || idx >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        byte curVal = this.mStorage[idx];
        this.mStorage[idx] = b;
        return curVal;
    }

    public int size() {
        return this.mCurBytes;
    }

    int getMaxSize() {
        return this.mMaxBytes;
    }
}

