/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class ByteArrayUtil {
    private static ByteBuffer getByteBuffer(byte[] bytes, int offset, int length, int containerSize) {
        byte[] data = new byte[containerSize];
        for (int i = 0; i < length; ++i) {
            data[i] = bytes[offset + i];
        }
        return ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN);
    }

    public static int getInt(byte[] bytes, int offset, int length) {
        return ByteArrayUtil.getByteBuffer(bytes, offset, length, 4).getInt();
    }

    public static long getLong(byte[] bytes, int offset, int length) {
        return ByteArrayUtil.getByteBuffer(bytes, offset, length, 8).getLong();
    }

    public static String getString(byte[] bytes, int offset, int length) {
        return new String(Arrays.copyOfRange(bytes, offset, offset + length));
    }
}

