/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.util.ArrayUtil;
import java.io.File;
import java.util.HashMap;
import java.util.List;

public class CircularAtraceUtil {
    private static final String ATRACE_START_CMD = "atrace --async_start -b %d -c %s -z";
    private static final String ATRACE_STOP_CMD = "atrace --async_stop -z -b %d > %s";
    private static final String DEFAULT_TAGS_STRING = "am gfx sched view";
    private static final String DEVICE_FILE = "${EXTERNAL_STORAGE}/atrace.txt";
    private static final int KB_IN_MB = 1000;
    private static HashMap<ITestDevice, Integer> deviceBufferMap = new HashMap();

    public static void startTrace(ITestDevice device, List<String> tags, int bufferSizeMB) throws DeviceNotAvailableException, IllegalStateException {
        if (device == null) {
            throw new IllegalStateException("Cannot start circular atrace without a device");
        }
        if (deviceBufferMap.containsKey(device)) {
            throw new IllegalStateException("Must end current atrace before starting another");
        }
        String tagsString = DEFAULT_TAGS_STRING;
        if (tags != null && !tags.isEmpty()) {
            tagsString = ArrayUtil.join(" ", tags);
        }
        String command = String.format(ATRACE_START_CMD, bufferSizeMB * 1000, tagsString);
        LogUtil.CLog.d("Starting circular atrace utility with command: %s", command);
        device.executeShellCommand(command);
        deviceBufferMap.put(device, bufferSizeMB);
    }

    public static FileInputStreamSource endTrace(ITestDevice device) throws DeviceNotAvailableException, IllegalStateException {
        if (!deviceBufferMap.containsKey(device)) {
            throw new IllegalStateException("Must start circular atrace before ending");
        }
        int bufferSizeKB = deviceBufferMap.remove(device) * 1000;
        String command = String.format(ATRACE_STOP_CMD, bufferSizeKB, DEVICE_FILE);
        LogUtil.CLog.d("Ending atrace utility with command: %s", command);
        device.executeShellCommand(command);
        File temp = device.pullFile(DEVICE_FILE);
        if (temp != null) {
            FileInputStreamSource stream = new FileInputStreamSource(temp);
            return stream;
        }
        LogUtil.CLog.w("Could not pull file: %s", DEVICE_FILE);
        return null;
    }
}

