/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.log.LogUtil;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;

public class ClassPathScanner {
    private String[] mClassPath = ClassPathScanner.getClassPath();

    public Map<String, String> getEntriesFromJar(File plainFile, IClassPathFilter filter) throws IOException {
        LinkedHashMap<String, String> entryNames = new LinkedHashMap<String, String>();
        JarFile jarFile = new JarFile(plainFile);
        Enumeration<JarEntry> e = jarFile.entries();
        while (e.hasMoreElements()) {
            String entryName = ((ZipEntry)e.nextElement()).getName();
            if (filter.accept(entryName)) {
                entryNames.put(filter.transform(entryName), plainFile.getName());
            }
            entryName = null;
        }
        jarFile.close();
        return entryNames;
    }

    public Set<String> getEntriesFromDir(File classPathDir, IClassPathFilter filter) throws IOException {
        LinkedHashSet<String> entryNames = new LinkedHashSet<String>();
        this.getEntriesFromDir(classPathDir, entryNames, new LinkedList<String>(), filter);
        return entryNames;
    }

    private void getEntriesFromDir(File dir, Set<String> entries, List<String> rootPath, IClassPathFilter filter) throws IOException {
        File[] childFiles = dir.listFiles();
        if (childFiles == null) {
            LogUtil.CLog.w("Directory %s in classPath is not readable, skipping", dir.getAbsolutePath());
            return;
        }
        for (File childFile : childFiles) {
            if (childFile.isDirectory()) {
                rootPath.add(childFile.getName() + "/");
                this.getEntriesFromDir(childFile, entries, rootPath, filter);
                rootPath.remove(rootPath.size() - 1);
                continue;
            }
            if (childFile.isFile()) {
                String classPathEntryName = this.constructPath(rootPath, childFile.getName());
                if (!filter.accept(classPathEntryName)) continue;
                entries.add(filter.transform(classPathEntryName));
                continue;
            }
            LogUtil.CLog.d("file %s in classPath is not recognized, skipping", dir.getAbsolutePath());
        }
    }

    private String constructPath(List<String> rootPath, String fileName) {
        StringBuilder pathBuilder = new StringBuilder();
        for (String element : rootPath) {
            pathBuilder.append(element);
        }
        pathBuilder.append(fileName);
        return pathBuilder.toString();
    }

    public Set<String> getClassPathEntries(IClassPathFilter filter) {
        LinkedHashSet<String> entryNames = new LinkedHashSet<String>();
        for (String classPathElement : this.mClassPath) {
            File classPathFile = new File(classPathElement);
            try {
                if (classPathFile.isFile() && classPathElement.endsWith(".jar")) {
                    entryNames.addAll(this.getEntriesFromJar(classPathFile, filter).keySet());
                    continue;
                }
                if (classPathFile.isDirectory()) {
                    entryNames.addAll(this.getEntriesFromDir(classPathFile, filter));
                    continue;
                }
                LogUtil.CLog.w("class path entry %s does not exist or is not recognized, skipping", classPathElement);
            }
            catch (IOException e) {
                LogUtil.CLog.w("Failed to read class path entry %s. Reason: %s", classPathElement, e.toString());
            }
        }
        return entryNames;
    }

    public Map<String, String> getClassPathEntriesFromJar(IClassPathFilter filter) {
        LinkedHashMap<String, String> entryNames = new LinkedHashMap<String, String>();
        for (String classPathElement : this.mClassPath) {
            File classPathFile = new File(classPathElement);
            try {
                if (classPathFile.isFile() && classPathElement.endsWith(".jar")) {
                    entryNames.putAll(this.getEntriesFromJar(classPathFile, filter));
                    continue;
                }
                LogUtil.CLog.w("class path entry %s does not exist or is not recognized, skipping", classPathElement);
            }
            catch (IOException e) {
                LogUtil.CLog.w("Failed to read class path entry %s. Reason: %s", classPathElement, e.toString());
            }
        }
        return entryNames;
    }

    public static String[] getClassPath() {
        String classPath = System.getProperty("java.class.path");
        return classPath.split(Pattern.quote(File.pathSeparator));
    }

    public static interface IClassPathFilter {
        public boolean accept(String var1);

        public String transform(String var1);
    }

    public static class ExternalClassNameFilter
    extends ClassNameFilter {
        @Override
        public boolean accept(String pathName) {
            return super.accept(pathName) && !pathName.contains("$");
        }
    }

    public static class ClassNameFilter
    implements IClassPathFilter {
        private static final String DOT_CLASS = ".class";

        @Override
        public boolean accept(String pathName) {
            return pathName.endsWith(DOT_CLASS);
        }

        @Override
        public String transform(String pathName) {
            String className = pathName.substring(0, pathName.length() - DOT_CLASS.length());
            className = className.replace('/', '.');
            return className;
        }
    }
}

