/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.device.CollectingOutputReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class DeviceConcurrentUtil {
    private DeviceConcurrentUtil() {
    }

    public static <T> T joinFuture(String taskDesc, Future<T> task, long timeout) throws DeviceNotAvailableException, TimeoutException {
        try {
            T ret = task.get(timeout, TimeUnit.MILLISECONDS);
            return ret;
        }
        catch (InterruptedException e) {
            LogUtil.CLog.e("interrupted while executing " + taskDesc);
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof DeviceNotAvailableException) {
                throw (DeviceNotAvailableException)t;
            }
            LogUtil.CLog.e("%s while executing %s", t.getClass().getSimpleName(), taskDesc);
            LogUtil.CLog.e(t);
        }
        return null;
    }

    public static abstract class ShellCommandCallable<V>
    implements Callable<V> {
        private String mCommand;
        private long mTimeout;
        private ITestDevice mDevice;

        public ShellCommandCallable() {
        }

        public ShellCommandCallable(ITestDevice device, String command, long timeout) {
            this();
            this.mCommand = command;
            this.mTimeout = timeout;
            this.mDevice = device;
        }

        public ShellCommandCallable<V> setCommand(String command) {
            this.mCommand = command;
            return this;
        }

        public ShellCommandCallable<V> setTimeout(long timeout) {
            this.mTimeout = timeout;
            return this;
        }

        public ShellCommandCallable<V> setDevice(ITestDevice device) {
            this.mDevice = device;
            return this;
        }

        @Override
        public V call() throws Exception {
            CollectingOutputReceiver receiver = new CollectingOutputReceiver();
            this.mDevice.executeShellCommand(this.mCommand, receiver, this.mTimeout, TimeUnit.MILLISECONDS, 1);
            String output = receiver.getOutput();
            LogUtil.CLog.v("raw output for \"%s\"\n%s", this.mCommand, output);
            return this.processOutput(output);
        }

        public abstract V processOutput(String var1);
    }
}

