/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.TimeoutException;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.IManagedTestDevice;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.RunUtil;
import java.io.IOException;

public class DeviceRecoveryModeUtil {
    public static void bootOutOfRecovery(IManagedTestDevice device, long timeoutMs) throws DeviceNotAvailableException {
        DeviceRecoveryModeUtil.bootOutOfRecovery(device, timeoutMs, 0L);
    }

    public static void bootOutOfRecovery(IManagedTestDevice managedDevice, long timeoutMs, long bufferMs) throws DeviceNotAvailableException {
        if (managedDevice.getDeviceState().equals((Object)TestDeviceState.RECOVERY)) {
            LogUtil.CLog.i("Rebooting to exit recovery");
            if (bufferMs > 0L) {
                LogUtil.CLog.i("Pausing for %d ms while recovery loads", bufferMs);
                RunUtil.getDefault().sleep(bufferMs);
            }
            try {
                managedDevice.getIDevice().reboot(null);
                managedDevice.waitForDeviceAvailable(timeoutMs);
                managedDevice.postBootSetup();
            }
            catch (AdbCommandRejectedException | TimeoutException | IOException e) {
                LogUtil.CLog.e("Failed to reboot, trying last-ditch recovery");
                LogUtil.CLog.e(e);
                managedDevice.recoverDevice();
            }
        }
    }
}

