/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class DirectedGraph<V> {
    private Map<V, List<V>> neighbors = new HashMap<V, List<V>>();

    public String toString() {
        StringBuffer s = new StringBuffer();
        for (V v : this.neighbors.keySet()) {
            s.append("\n    " + v + " -> " + this.neighbors.get(v));
        }
        return s.toString();
    }

    public void addVertice(V vertex) {
        if (this.neighbors.containsKey(vertex)) {
            return;
        }
        this.neighbors.put(vertex, new ArrayList());
    }

    public boolean contains(V vertex) {
        return this.neighbors.containsKey(vertex);
    }

    public void addEdge(V from, V to) {
        this.addVertice(from);
        this.addVertice(to);
        this.neighbors.get(from).add(to);
    }

    public void removeEdge(V from, V to) {
        if (!this.contains(from) || !this.contains(to)) {
            throw new IllegalArgumentException("Nonexistent vertex");
        }
        this.neighbors.get(from).remove(to);
    }

    private Map<V, Integer> inDegree() {
        HashMap<V, Integer> result = new HashMap<V, Integer>();
        for (V v : this.neighbors.keySet()) {
            result.put(v, 0);
        }
        for (V from : this.neighbors.keySet()) {
            for (V to : this.neighbors.get(from)) {
                result.put(to, (Integer)result.get(to) + 1);
            }
        }
        return result;
    }

    private List<V> topSort() {
        Map<Integer, Integer> degree = this.inDegree();
        Stack<V> zeroVerts = new Stack<V>();
        for (Object v : degree.keySet()) {
            if (degree.get(v) != 0) continue;
            zeroVerts.push(v);
        }
        ArrayList<V> result = new ArrayList<V>();
        while (!zeroVerts.isEmpty()) {
            Object v;
            v = zeroVerts.pop();
            result.add(v);
            for (V neighbor : this.neighbors.get(v)) {
                degree.put((Integer)neighbor, degree.get(neighbor) - 1);
                if (degree.get(neighbor) != 0) continue;
                zeroVerts.push(neighbor);
            }
        }
        if (result.size() != this.neighbors.size()) {
            return null;
        }
        return result;
    }

    public boolean isDag() {
        return this.topSort() != null;
    }
}

