/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class FakeTestsZipFolder {
    private Map<String, ItemType> mItems;
    private File mBase;
    private File mData;

    public FakeTestsZipFolder(Map<String, ItemType> items) {
        this.mItems = items;
    }

    public boolean createItems() throws IOException {
        this.mBase = File.createTempFile("tf_", "_test_zip");
        this.mBase.delete();
        this.mData = new File(this.mBase, "DATA");
        if (!this.mData.mkdirs()) {
            return false;
        }
        boolean failed = false;
        for (String fileName : this.mItems.keySet()) {
            File file2 = new File(this.mData, fileName);
            ItemType type = this.mItems.get(fileName);
            if (ItemType.DIRECTORY.equals((Object)type)) {
                if (file2.mkdirs()) continue;
                failed = true;
                break;
            }
            File p = file2.getParentFile();
            if (!p.exists() && !p.mkdirs()) {
                failed = true;
                break;
            }
            if (file2.createNewFile()) continue;
            failed = true;
            break;
        }
        if (failed) {
            this.cleanUp();
        }
        return !failed;
    }

    public void cleanUp() {
        FileUtil.recursiveDelete(this.mBase);
    }

    protected File getDataFolder() {
        return this.mData;
    }

    public File getBasePath() {
        return this.mBase;
    }

    public static enum ItemType {
        FILE,
        DIRECTORY;

    }
}

