/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.log.LogUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class FileIdleMonitor {
    private final Duration mTimeout;
    private final Runnable mCallback;
    private final Set<File> mFiles;
    private final Supplier<ScheduledExecutorService> mExecutorSupplier;
    private ScheduledExecutorService mExecutor;

    public FileIdleMonitor(Duration timeout, Runnable callback, File ... files) {
        this(Executors::newSingleThreadScheduledExecutor, timeout, callback, files);
    }

    @VisibleForTesting
    FileIdleMonitor(Supplier<ScheduledExecutorService> executorSupplier, Duration timeout, Runnable callback, File ... files) {
        this.mExecutorSupplier = executorSupplier;
        this.mTimeout = timeout;
        this.mCallback = callback;
        this.mFiles = Sets.newHashSet(files);
    }

    public void start() {
        if (this.mExecutor == null) {
            this.mExecutor = this.mExecutorSupplier.get();
            this.checkIfIdle();
        }
    }

    public void stop() {
        if (this.mExecutor != null) {
            this.mExecutor.shutdownNow();
            this.mExecutor = null;
        }
    }

    private long getTimestamp() {
        return this.mFiles.stream().map(File::lastModified).max(Long::compare).orElse(0L);
    }

    private void checkIfIdle() {
        long timestamp = this.getTimestamp();
        if (timestamp == 0L) {
            this.scheduleCheck(this.mTimeout);
            return;
        }
        Duration elapsed = Duration.between(Instant.ofEpochMilli(timestamp), Instant.now());
        Duration remaining = this.mTimeout.minus(elapsed);
        if (remaining.isNegative()) {
            this.executeCallback();
            this.scheduleCheck(this.mTimeout);
        } else {
            this.scheduleCheck(remaining);
        }
    }

    private void scheduleCheck(Duration delay) {
        this.mExecutor.schedule(this::checkIfIdle, delay.toMillis(), TimeUnit.MILLISECONDS);
    }

    private void executeCallback() {
        try {
            this.mCallback.run();
        }
        catch (RuntimeException e) {
            LogUtil.CLog.e("Failed to execute callback");
            LogUtil.CLog.e(e);
        }
    }
}

