/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.command.FatalHostError;
import com.android.tradefed.config.Option;
import com.android.tradefed.error.HarnessIOException;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.util.AbiUtils;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.ZipUtil;
import com.google.common.collect.ImmutableSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import java.util.zip.ZipFile;

public class FileUtil {
    private static final ImmutableSet<String> DISK_SPACE_ERRORS = ImmutableSet.of("No space left on device");
    @Option(name="min-disk-space", description="The minimum allowed disk space in megabytes for file-creation methods. May be set to 0 to disable checking.")
    private static long mMinDiskSpaceMb = 100L;
    private static final char[] SIZE_SPECIFIERS = new char[]{' ', 'K', 'M', 'G', 'T'};
    private static String sChmod = "chmod";
    private static final Map<PosixFilePermission, Integer> PERM_MODE_MAP = new HashMap<PosixFilePermission, Integer>();
    public static final int FILESYSTEM_FILENAME_MAX_LENGTH = 255;

    protected static void setChmodBinary(String chmodName) {
        sChmod = chmodName;
    }

    public static boolean mkdirsRWX(File file2) {
        boolean setPerms;
        File parent = file2.getParentFile();
        if (parent != null && !parent.isDirectory() && !FileUtil.mkdirsRWX(parent)) {
            LogUtil.CLog.w("Failed to mkdir parent dir %s.", parent);
            return false;
        }
        if ((file2.isDirectory() || file2.mkdir()) && !(setPerms = FileUtil.chmodGroupRWX(file2))) {
            LogUtil.CLog.w("Failed to set dir %s to be group accessible.", file2);
        }
        return file2.isDirectory();
    }

    public static boolean chmodRWXRecursively(File file2) {
        boolean success = true;
        if (!file2.setExecutable(true, false)) {
            LogUtil.CLog.w("Failed to set %s executable.", file2.getAbsolutePath());
            success = false;
        }
        if (!file2.setWritable(true, false)) {
            LogUtil.CLog.w("Failed to set %s writable.", file2.getAbsolutePath());
            success = false;
        }
        if (!file2.setReadable(true, false)) {
            LogUtil.CLog.w("Failed to set %s readable", file2.getAbsolutePath());
            success = false;
        }
        if (file2.isDirectory()) {
            File[] children;
            for (File child : children = file2.listFiles()) {
                if (FileUtil.chmodRWXRecursively(child)) continue;
                success = false;
            }
        }
        return success;
    }

    public static boolean chmod(File file2, String perms) {
        CommandResult result = RunUtil.getDefault().runTimedCmd(10000L, sChmod, perms, file2.getAbsolutePath());
        return result.getStatus().equals((Object)CommandStatus.SUCCESS);
    }

    public static boolean chmodGroupRW(File file2) {
        if (FileUtil.chmodExists()) {
            if (FileUtil.chmod(file2, "ug+rw")) {
                return true;
            }
            LogUtil.CLog.d("Failed chmod on %s", file2.getAbsolutePath());
            return false;
        }
        LogUtil.CLog.d("chmod not available; attempting to set %s globally RW", file2.getAbsolutePath());
        return file2.setWritable(true, false) && file2.setReadable(true, false);
    }

    public static boolean chmodGroupRWX(File file2) {
        if (FileUtil.chmodExists()) {
            if (FileUtil.chmod(file2, "ug+rwx")) {
                return true;
            }
            LogUtil.CLog.d("Failed chmod on %s", file2.getAbsolutePath());
            return false;
        }
        LogUtil.CLog.d("chmod not available; attempting to set %s globally RWX", file2.getAbsolutePath());
        return file2.setExecutable(true, false) && file2.setWritable(true, false) && file2.setReadable(true, false);
    }

    protected static boolean chmodExists() {
        CommandResult result = RunUtil.getDefault().runTimedCmdSilently(10000L, sChmod);
        if (result.getExitCode() != null && result.getExitCode() != 127 && result.getExitCode() != 88) {
            return true;
        }
        LogUtil.CLog.w("Chmod is not supported by this OS.");
        return false;
    }

    public static void setReadableRecursive(File file2) {
        file2.setReadable(true);
        if (file2.isDirectory()) {
            file2.setExecutable(true);
            File[] children = file2.listFiles();
            if (children != null) {
                for (File childFile : file2.listFiles()) {
                    FileUtil.setReadableRecursive(childFile);
                }
            }
        }
    }

    public static File createTempDir(String prefix) throws IOException {
        return FileUtil.createTempDir(prefix, null);
    }

    public static File createTempDir(String prefix, File parentDir) throws IOException {
        if (parentDir != null) {
            LogUtil.CLog.d("Creating temp directory at %s with prefix \"%s\"", parentDir.getAbsolutePath(), prefix);
        }
        File tmpDir = File.createTempFile(prefix, "", parentDir);
        return FileUtil.deleteFileAndCreateDirWithSameName(tmpDir);
    }

    private static File deleteFileAndCreateDirWithSameName(File tmpDir) throws IOException {
        tmpDir.delete();
        return FileUtil.createDir(tmpDir);
    }

    private static File createDir(File tmpDir) throws IOException {
        if (!tmpDir.mkdirs()) {
            throw new IOException("unable to create directory");
        }
        return tmpDir;
    }

    public static File createNamedTempDir(String name) throws IOException {
        File namedTmpDir = new File(System.getProperty("java.io.tmpdir"), name);
        if (!namedTmpDir.exists()) {
            FileUtil.createDir(namedTmpDir);
        }
        return namedTmpDir;
    }

    public static File createNamedTempDir(File parentDir, String name) throws IOException {
        String parentPath = parentDir == null ? System.getProperty("java.io.tmpdir") : parentDir.getAbsolutePath();
        File namedTmpDir = new File(parentPath, name);
        if (!namedTmpDir.exists()) {
            FileUtil.createDir(namedTmpDir);
        }
        return namedTmpDir;
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return FileUtil.internalCreateTempFile(prefix, suffix, null);
    }

    public static File createTempFile(String prefix, String suffix, File parentDir) throws IOException {
        return FileUtil.internalCreateTempFile(prefix, suffix, parentDir);
    }

    private static File internalCreateTempFile(String prefix, String suffix, File parentDir) throws IOException {
        int overflowLength = prefix.length() + 19 - 255;
        if (suffix != null) {
            overflowLength += suffix.length();
        }
        if (overflowLength > 0) {
            LogUtil.CLog.w("Filename for prefix: %s and suffix: %s, would be too long for FileSystem,truncating it.", prefix, suffix);
            if (suffix.length() >= overflowLength) {
                int temp = overflowLength;
                overflowLength -= suffix.length();
                suffix = suffix.substring(temp, suffix.length());
            } else {
                overflowLength -= suffix.length();
                suffix = "";
            }
            if (overflowLength > 0) {
                prefix = prefix.substring(0, prefix.length() - overflowLength);
            }
        }
        File returnFile = null;
        if (parentDir != null) {
            LogUtil.CLog.d("Creating temp file at %s with prefix \"%s\" suffix \"%s\"", parentDir.getAbsolutePath(), prefix, suffix);
        }
        try {
            returnFile = File.createTempFile(prefix, suffix, parentDir);
        }
        catch (IOException e) {
            throw new HarnessIOException(e, InfraErrorIdentifier.LAB_HOST_FILESYSTEM_ERROR);
        }
        FileUtil.verifyDiskSpace(returnFile);
        return returnFile;
    }

    public static void hardlinkFile(File origFile, File destFile) throws IOException {
        FileUtil.hardlinkFile(origFile, destFile, false);
    }

    public static void hardlinkFile(File origFile, File destFile, boolean ignoreExistingFile) throws IOException {
        try {
            Files.createLink(destFile.toPath(), origFile.toPath());
        }
        catch (FileAlreadyExistsException e) {
            if (!ignoreExistingFile) {
                throw e;
            }
        }
        catch (FileSystemException e) {
            if (e.getMessage().contains("Invalid cross-device link")) {
                LogUtil.CLog.d("Hardlink failed: '%s', falling back to copy.", e.getMessage());
                FileUtil.copyFile(origFile, destFile);
                return;
            }
            throw e;
        }
    }

    public static void symlinkFile(File origFile, File destFile) throws IOException {
        LogUtil.CLog.d("Attempting symlink from %s to %s", origFile.getAbsolutePath(), destFile.getAbsolutePath());
        Files.createSymbolicLink(destFile.toPath(), origFile.toPath(), new FileAttribute[0]);
    }

    public static void recursiveHardlink(File sourceDir, File destDir) throws IOException {
        FileUtil.recursiveHardlink(sourceDir, destDir, false);
    }

    public static void recursiveHardlink(File sourceDir, File destDir, boolean ignoreExistingFile) throws IOException {
        FileUtil.recursiveHardlink(sourceDir, destDir, ignoreExistingFile, new HashSet<String>());
    }

    public static void recursiveHardlink(File sourceDir, File destDir, boolean ignoreExistingFile, Set<String> copyInsteadofHardlink) throws IOException {
        if (!destDir.isDirectory() && !destDir.mkdir()) {
            throw new IOException(String.format("Could not create directory %s", destDir.getAbsolutePath()));
        }
        for (File childFile : sourceDir.listFiles()) {
            File destChild = new File(destDir, childFile.getName());
            if (childFile.isDirectory()) {
                FileUtil.recursiveHardlink(childFile, destChild, ignoreExistingFile);
                continue;
            }
            if (!childFile.isFile()) continue;
            if (copyInsteadofHardlink.contains(childFile.getName())) {
                FileUtil.copyFile(childFile, destChild);
                continue;
            }
            FileUtil.hardlinkFile(childFile, destChild, ignoreExistingFile);
        }
    }

    public static void recursiveSymlink(File sourceDir, File destDir) throws IOException {
        if (!destDir.isDirectory() && !destDir.mkdir()) {
            throw new IOException(String.format("Could not create directory %s", destDir.getAbsolutePath()));
        }
        for (File childFile : sourceDir.listFiles()) {
            File destChild = new File(destDir, childFile.getName());
            if (childFile.isDirectory()) {
                FileUtil.recursiveSymlink(childFile, destChild);
                continue;
            }
            if (!childFile.isFile()) continue;
            FileUtil.symlinkFile(childFile, destChild);
        }
    }

    public static void copyFile(File origFile, File destFile) throws IOException {
        FileUtil.writeToFile(new FileInputStream(origFile), destFile);
    }

    public static void recursiveCopy(File sourceDir, File destDir) throws IOException {
        File[] childFiles = sourceDir.listFiles();
        if (childFiles == null) {
            throw new IOException(String.format("Failed to recursively copy. Could not determine contents for directory '%s'", sourceDir.getAbsolutePath()));
        }
        if (!destDir.isDirectory() && !destDir.mkdir()) {
            throw new IOException(String.format("Could not create directory %s", destDir.getAbsolutePath()));
        }
        for (File childFile : childFiles) {
            File destChild = new File(destDir, childFile.getName());
            if (childFile.isDirectory()) {
                FileUtil.recursiveCopy(childFile, destChild);
                continue;
            }
            if (!childFile.isFile()) continue;
            FileUtil.copyFile(childFile, destChild);
        }
    }

    public static String readStringFromFile(File sourceFile) throws IOException {
        return FileUtil.readStringFromFile(sourceFile, 0L, 0L);
    }

    public static String readStringFromFile(File sourceFile, long startOffset, long length) throws IOException {
        try (FileInputStream is = new FileInputStream(sourceFile);){
            if (startOffset < 0L) {
                startOffset = 0L;
            }
            long fileLength = sourceFile.length();
            is.skip(startOffset);
            if (length <= 0L || fileLength <= startOffset + length) {
                String string = StreamUtil.getStringFromStream(is);
                return string;
            }
            String string = StreamUtil.getStringFromStream(is, length);
            return string;
        }
    }

    public static void writeToFile(String inputString, File destFile) throws IOException {
        FileUtil.writeToFile(inputString, destFile, false);
    }

    public static void writeToFile(String inputString, File destFile, boolean append) throws IOException {
        FileUtil.writeToFile(new ByteArrayInputStream(inputString.getBytes()), destFile, append);
    }

    public static void writeToFile(InputStream input, File destFile) throws IOException {
        FileUtil.writeToFile(input, destFile, false);
    }

    public static void writeToFile(InputStream input, File destFile, boolean append) throws IOException {
        FileUtil.writeToFile(input, destFile, append, 0L, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(InputStream input, File destFile, boolean append, long startOffset, long size) throws IOException {
        BufferedInputStream origStream = null;
        BufferedOutputStream destStream = null;
        try {
            origStream = new BufferedInputStream(input);
            destStream = new BufferedOutputStream(new FileOutputStream(destFile, append));
            StreamUtil.copyStreams(origStream, destStream, startOffset, size);
        }
        catch (Throwable throwable) {
            StreamUtil.close(origStream);
            StreamUtil.flushAndCloseStream(destStream);
            throw throwable;
        }
        StreamUtil.close(origStream);
        StreamUtil.flushAndCloseStream(destStream);
    }

    private static void verifyDiskSpace(File file2) {
        long minDiskSpace;
        long usableSpace = 0L;
        File toCheck = file2;
        if (!file2.isDirectory() && file2.getParentFile() != null) {
            toCheck = file2.getParentFile();
        }
        if ((usableSpace = toCheck.getUsableSpace()) < (minDiskSpace = mMinDiskSpaceMb * 1024L * 1024L)) {
            String message2 = String.format("Available space on %s is %.2f MB. Min is %d MB.", toCheck.getAbsolutePath(), (double)usableSpace / 1048576.0, mMinDiskSpaceMb);
            throw new LowDiskSpaceException(message2);
        }
    }

    public static void recursiveDelete(File rootDir) {
        if (rootDir != null) {
            File[] childFiles;
            if (rootDir.isDirectory() && !Files.isSymbolicLink(rootDir.toPath()) && (childFiles = rootDir.listFiles()) != null) {
                for (File child : childFiles) {
                    FileUtil.recursiveDelete(child);
                }
            }
            rootDir.delete();
        }
    }

    public static String getExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return fileName.substring(index);
    }

    public static String getBaseName(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return fileName;
        }
        return fileName.substring(0, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean compareFileContents(File file1, File file2) throws IOException {
        BufferedInputStream stream1 = null;
        BufferedInputStream stream2 = null;
        boolean result = true;
        try {
            stream1 = new BufferedInputStream(new FileInputStream(file1));
            stream2 = new BufferedInputStream(new FileInputStream(file2));
            boolean eof = false;
            while (!eof) {
                int byte2;
                int byte1 = stream1.read();
                if (byte1 != (byte2 = stream2.read())) {
                    result = false;
                    break;
                }
                eof = byte1 == -1;
            }
        }
        catch (Throwable throwable) {
            StreamUtil.close(stream1);
            StreamUtil.close(stream2);
            throw throwable;
        }
        StreamUtil.close(stream1);
        StreamUtil.close(stream2);
        return result;
    }

    public static File createTempFileForRemote(String remoteFilePath, File parentDir) throws IOException {
        String[] segments = remoteFilePath.split("/");
        String remoteFileName = segments[segments.length - 1];
        String prefix = FileUtil.getBaseName(remoteFileName);
        if (prefix.length() < 3) {
            prefix = prefix + "XXX";
        }
        String fileExt = FileUtil.getExtension(remoteFileName);
        File tmpFile = FileUtil.createTempFile(prefix + "_", fileExt, parentDir);
        return tmpFile;
    }

    public static void deleteFile(File file2) {
        if (file2 != null) {
            file2.delete();
        }
    }

    public static File getFileForPath(File parentDir, String ... pathSegments) {
        return new File(parentDir, FileUtil.getPath(pathSegments));
    }

    public static String getPath(String ... pathSegments) {
        StringBuilder pathBuilder = new StringBuilder();
        boolean isFirst = true;
        for (String path : pathSegments) {
            if (!isFirst) {
                pathBuilder.append(File.separatorChar);
            } else {
                isFirst = false;
            }
            pathBuilder.append(path);
        }
        return pathBuilder.toString();
    }

    public static File findFile(File dir, String fileName) {
        if (dir.listFiles() != null) {
            for (File file2 : dir.listFiles()) {
                File result;
                if (file2.isDirectory() && (result = FileUtil.findFile(file2, fileName)) != null) {
                    return result;
                }
                if (!file2.getName().matches(fileName)) continue;
                return file2;
            }
        }
        return null;
    }

    public static File findFile(String fileName, IAbi abi, File ... dirs) throws IOException {
        for (File dir : dirs) {
            Set<File> testSrcs = FileUtil.findFilesObject(dir, fileName);
            if (testSrcs.isEmpty()) continue;
            Iterator<File> itr = testSrcs.iterator();
            if (abi == null) {
                return itr.next();
            }
            while (itr.hasNext()) {
                File matchFile = itr.next();
                if (!matchFile.getParentFile().getName().equals(AbiUtils.getArchForAbi(abi.getName()))) continue;
                return matchFile;
            }
        }
        for (File dir : dirs) {
            File matchFile = FileUtil.findFile(dir, fileName);
            if (matchFile == null || !matchFile.exists()) continue;
            return matchFile;
        }
        return null;
    }

    public static Set<File> findDirsUnder(File rootDir, File relativeParent) {
        HashSet<File> dirs = new HashSet<File>();
        if (rootDir != null) {
            if (!rootDir.isDirectory()) {
                throw new IllegalArgumentException("Can't find dirs under '" + rootDir + "'. It's not a directory.");
            }
            File thisDir = new File(relativeParent, rootDir.getName());
            dirs.add(thisDir);
            for (File file2 : rootDir.listFiles()) {
                if (!file2.isDirectory()) continue;
                dirs.addAll(FileUtil.findDirsUnder(file2, thisDir));
            }
        }
        return dirs;
    }

    public static String convertToReadableSize(long sizeLong) {
        double size = sizeLong;
        for (int i = 0; i < SIZE_SPECIFIERS.length; ++i) {
            if (size < 1024.0) {
                return String.format("%.1f%c", size, Character.valueOf(SIZE_SPECIFIERS[i]));
            }
            size /= 1024.0;
        }
        throw new IllegalArgumentException(String.format("Passed a file size of %.2f, I cannot count that high", size));
    }

    public static long convertSizeToBytes(String sizeString) throws IllegalArgumentException {
        if (sizeString.isEmpty()) {
            throw new IllegalArgumentException("invalid empty string");
        }
        char sizeSpecifier = sizeString.charAt(sizeString.length() - 1);
        long multiplier = FileUtil.findMultiplier(sizeSpecifier);
        try {
            String numberString = sizeString;
            if (multiplier != 1L) {
                numberString = sizeString.substring(0, sizeString.length() - 1);
            }
            return multiplier * Long.parseLong(numberString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Unrecognized size %s", sizeString));
        }
    }

    private static long findMultiplier(char sizeSpecifier) {
        long multiplier = 1L;
        for (int i = 1; i < SIZE_SPECIFIERS.length; ++i) {
            multiplier *= 1024L;
            if (sizeSpecifier != SIZE_SPECIFIERS[i]) continue;
            return multiplier;
        }
        return 1L;
    }

    public static List<File> collectJars(File dir) {
        ArrayList<File> list2 = new ArrayList<File>();
        File[] jarFiles = dir.listFiles(new JarFilter());
        if (jarFiles != null) {
            list2.addAll(Arrays.asList(dir.listFiles(new JarFilter())));
        }
        return list2;
    }

    @Deprecated
    public static void extractZip(ZipFile zipFile, File destDir) throws IOException {
        ZipUtil.extractZip(zipFile, destDir);
    }

    @Deprecated
    public static File extractFileFromZip(ZipFile zipFile, String filePath) throws IOException {
        return ZipUtil.extractFileFromZip(zipFile, filePath);
    }

    @Deprecated
    public static File createZip(File dir) throws IOException {
        return ZipUtil.createZip(dir);
    }

    @Deprecated
    public static void createZip(File dir, File zipFile) throws IOException {
        ZipUtil.createZip(dir, zipFile);
    }

    @Deprecated
    public static void closeZip(ZipFile zipFile) {
        ZipUtil.closeZip(zipFile);
    }

    @Deprecated
    public static void gzipFile(File file2, File gzipFile) throws IOException {
        ZipUtil.gzipFile(file2, gzipFile);
    }

    public static long calculateCrc32(File file2) throws IOException {
        try (BufferedInputStream inputSource = new BufferedInputStream(new FileInputStream(file2));){
            long l = StreamUtil.calculateCrc32(inputSource);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String calculateMd5(File file2) {
        block10: {
            long startTime = System.currentTimeMillis();
            try {
                String string;
                FileInputStream inputSource = new FileInputStream(file2);
                try {
                    string = StreamUtil.calculateMd5(inputSource);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            inputSource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        LogUtil.CLog.e(e);
                        break block10;
                    }
                }
                inputSource.close();
                return string;
            }
            finally {
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.MD5_CALCULATION_TIME, System.currentTimeMillis() - startTime);
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.MD5_CALCULATION_COUNT, 1L);
            }
        }
        return "-1";
    }

    public static String calculateBase64Md5(File file2) {
        String string;
        FileInputStream inputSource = new FileInputStream(file2);
        try {
            string = StreamUtil.calculateBase64Md5(inputSource);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputSource.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LogUtil.CLog.e(e);
                return "-1";
            }
        }
        inputSource.close();
        return string;
    }

    public static Set<PosixFilePermission> unixModeToPosix(int mode) {
        EnumSet<PosixFilePermission> result = EnumSet.noneOf(PosixFilePermission.class);
        for (PosixFilePermission pfp : EnumSet.allOf(PosixFilePermission.class)) {
            int m = PERM_MODE_MAP.get((Object)pfp);
            if ((m & mode) != m) continue;
            result.add(pfp);
        }
        return result;
    }

    public static Set<String> findFiles(File dir, String filter) throws IOException {
        HashSet<String> files = new HashSet<String>();
        try (Stream<Path> stream = Files.walk(Paths.get(dir.getAbsolutePath(), new String[0]), FileVisitOption.FOLLOW_LINKS);){
            stream.filter(path -> path.getFileName().toString().matches(filter)).forEach(path -> files.add(path.toString()));
        }
        return files;
    }

    public static Set<File> findFiles(String fileName, IAbi abi, boolean includeDirectory, File ... dirs) throws IOException {
        LinkedHashSet<File> abiSpecificFiles = new LinkedHashSet<File>();
        LinkedHashSet<File> allFiles = new LinkedHashSet<File>();
        for (File dir : dirs) {
            Set<File> testSrcs = FileUtil.findFilesObject(dir, fileName, includeDirectory);
            allFiles.addAll(testSrcs);
            if (testSrcs.isEmpty()) continue;
            Iterator<File> itr = testSrcs.iterator();
            if (abi == null) continue;
            while (itr.hasNext()) {
                File matchFile = itr.next();
                if (!matchFile.getParentFile().getName().equals(AbiUtils.getArchForAbi(abi.getName()))) continue;
                abiSpecificFiles.add(matchFile);
            }
        }
        if (!abiSpecificFiles.isEmpty()) {
            return abiSpecificFiles;
        }
        return allFiles;
    }

    public static File findDirectory(String dirName, File ... dirs) throws IOException {
        for (File dir : dirs) {
            Set<File> testSrcs = FileUtil.findFilesObject(dir, dirName);
            if (testSrcs.isEmpty()) continue;
            for (File file2 : testSrcs) {
                if (!file2.isDirectory()) continue;
                return file2;
            }
        }
        return null;
    }

    public static Set<File> findFilesObject(File dir, String filter) throws IOException {
        return FileUtil.findFilesObject(dir, filter, true);
    }

    public static Set<File> findFilesObject(File dir, String filter, boolean includeDirectory) throws IOException {
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        try (Stream<Path> stream = Files.walk(Paths.get(dir.getAbsolutePath(), new String[0]), FileVisitOption.FOLLOW_LINKS);){
            if (includeDirectory) {
                stream.filter(path -> path.getFileName().toString().matches(filter)).forEach(path -> files.add(path.toFile()));
            } else {
                stream.filter(path -> path.getFileName().toString().matches(filter) && path.toFile().isFile()).forEach(path -> files.add(path.toFile()));
            }
        }
        return files;
    }

    public static String getContentType(String filePath) {
        LogDataType[] dataTypes;
        int index = filePath.lastIndexOf(46);
        String ext = "";
        if (index >= 0) {
            ext = filePath.substring(index + 1);
        }
        for (LogDataType dataType : dataTypes = LogDataType.values()) {
            if (!ext.equals(dataType.getFileExt())) continue;
            return dataType.getContentType();
        }
        return LogDataType.UNKNOWN.getContentType();
    }

    public static File saveResourceFile(InputStream resourceStream, File destDir, String targetFileName) throws IOException {
        FileWriter writer = null;
        File file2 = Paths.get(destDir.getAbsolutePath(), targetFileName).toFile();
        try {
            writer = new FileWriter(file2);
            StreamUtil.copyStreamToWriter(resourceStream, writer);
            File file3 = file2;
            return file3;
        }
        catch (IOException e) {
            LogUtil.CLog.e("IOException while saving resource %s/%s", destDir, targetFileName);
            FileUtil.deleteFile(file2);
            throw e;
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (resourceStream != null) {
                resourceStream.close();
            }
        }
    }

    public static Long sizeOfDirectory(File directory) {
        if (directory == null || !directory.isDirectory()) {
            return null;
        }
        Path folder = directory.getAbsoluteFile().toPath();
        try {
            long size = 0L;
            try (Stream<Path> stream = Files.walk(folder, FileVisitOption.FOLLOW_LINKS);){
                size = stream.filter(p -> p.toFile().isFile()).mapToLong(p -> p.toFile().length()).sum();
            }
            LogUtil.CLog.d("Directory '%s' has size: %s. Contains: %s", directory, size, Arrays.asList(directory.list()));
            return size;
        }
        catch (IOException | RuntimeException e) {
            LogUtil.CLog.e(e);
            return null;
        }
    }

    public static boolean isDiskSpaceError(String message2) {
        return DISK_SPACE_ERRORS.contains(message2);
    }

    public static IOException convertToDiskSpaceIfNeeded(IOException e) {
        if (FileUtil.isDiskSpaceError(e.getMessage())) {
            return new HarnessIOException(e, InfraErrorIdentifier.NO_DISK_SPACE);
        }
        return e;
    }

    static {
        PERM_MODE_MAP.put(PosixFilePermission.OWNER_READ, 256);
        PERM_MODE_MAP.put(PosixFilePermission.OWNER_WRITE, 128);
        PERM_MODE_MAP.put(PosixFilePermission.OWNER_EXECUTE, 64);
        PERM_MODE_MAP.put(PosixFilePermission.GROUP_READ, 32);
        PERM_MODE_MAP.put(PosixFilePermission.GROUP_WRITE, 16);
        PERM_MODE_MAP.put(PosixFilePermission.GROUP_EXECUTE, 8);
        PERM_MODE_MAP.put(PosixFilePermission.OTHERS_READ, 4);
        PERM_MODE_MAP.put(PosixFilePermission.OTHERS_WRITE, 2);
        PERM_MODE_MAP.put(PosixFilePermission.OTHERS_EXECUTE, 1);
    }

    public static class LowDiskSpaceException
    extends FatalHostError {
        LowDiskSpaceException(String msg, Throwable cause) {
            super(msg, cause, InfraErrorIdentifier.LAB_HOST_FILESYSTEM_FULL);
        }

        LowDiskSpaceException(String msg) {
            super(msg, InfraErrorIdentifier.LAB_HOST_FILESYSTEM_FULL);
        }
    }

    private static class JarFilter
    implements FilenameFilter {
        private JarFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    }
}

