/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;

public class FixedByteArrayOutputStream
extends OutputStream {
    private final byte[] mBuffer;
    private int mWritePos = 0;
    private boolean mHasWrapped = false;

    public FixedByteArrayOutputStream(int maxDataSize) {
        this.mBuffer = new byte[maxDataSize];
    }

    public InputStream getData() {
        if (this.mHasWrapped) {
            ByteArrayInputStream s1 = new ByteArrayInputStream(this.mBuffer, this.mWritePos, this.mBuffer.length - this.mWritePos);
            ByteArrayInputStream s2 = new ByteArrayInputStream(this.mBuffer, 0, this.mWritePos);
            return new SequenceInputStream(s1, s2);
        }
        return new ByteArrayInputStream(this.mBuffer, 0, this.mWritePos);
    }

    @Override
    public void write(int data) throws IOException {
        this.mBuffer[this.mWritePos] = (byte)data;
        ++this.mWritePos;
        if (this.mWritePos >= this.mBuffer.length) {
            this.mHasWrapped = true;
            this.mWritePos = 0;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (len >= this.mBuffer.length) {
            System.arraycopy(b, off + len - this.mBuffer.length, this.mBuffer, 0, this.mBuffer.length);
            this.mHasWrapped = true;
            this.mWritePos = 0;
        } else {
            int freeSpace = this.mBuffer.length - this.mWritePos;
            if (freeSpace >= len) {
                System.arraycopy(b, off, this.mBuffer, this.mWritePos, len);
            } else {
                System.arraycopy(b, off, this.mBuffer, this.mWritePos, freeSpace);
                System.arraycopy(b, off + freeSpace, this.mBuffer, 0, len - freeSpace);
            }
            this.mWritePos += len;
            if (this.mWritePos > this.mBuffer.length) {
                this.mHasWrapped = true;
                this.mWritePos %= this.mBuffer.length;
            }
        }
    }

    public long size() {
        if (this.mHasWrapped) {
            return this.mBuffer.length;
        }
        return this.mWritePos;
    }
}

