/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.build.BuildInfoKey;
import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.config.remote.ExtendedFile;
import com.android.tradefed.invoker.logger.CurrentInvocation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.FlashingResourcesParser;
import com.android.tradefed.targetprep.IFlashingResourcesParser;
import com.android.tradefed.targetprep.TargetSetupError;
import com.google.common.base.Strings;
import java.io.File;
import java.util.Map;

public class FlashingResourceUtil {
    public static boolean setUpFlashingResources(IBuildInfo info, Map<String, File> keyAndFiles) throws BuildRetrievalError {
        FlashingResourcesParser flashingResourcesParser = null;
        String deviceImageFlavor = null;
        String buildId = "downloaded";
        File deviceImage = keyAndFiles.get(BuildInfoKey.BuildInfoFileKey.DEVICE_IMAGE.getFileKey());
        if (deviceImage == null) {
            return false;
        }
        if (!(deviceImage instanceof ExtendedFile)) {
            return false;
        }
        String bid = ((ExtendedFile)deviceImage).getBuildId();
        if (!Strings.isNullOrEmpty(bid)) {
            buildId = bid;
        }
        try {
            flashingResourcesParser = new FlashingResourcesParser(deviceImage);
            deviceImageFlavor = ((ExtendedFile)deviceImage).getBuildTarget();
        }
        catch (TargetSetupError e) {
            throw new BuildRetrievalError("Failed to get image info from android-info.txt", (Throwable)e, InfraErrorIdentifier.ARTIFACT_DOWNLOAD_ERROR);
        }
        info.setFile(BuildInfoKey.BuildInfoFileKey.DEVICE_IMAGE, deviceImage, buildId);
        if (CurrentInvocation.getInvocationFiles() != null) {
            CurrentInvocation.getInvocationFiles().put(BuildInfoKey.BuildInfoFileKey.DEVICE_IMAGE.getFileKey(), deviceImage);
        }
        keyAndFiles.remove(BuildInfoKey.BuildInfoFileKey.DEVICE_IMAGE.getFileKey());
        File bootloader = keyAndFiles.get(BuildInfoKey.BuildInfoFileKey.BOOTLOADER_IMAGE.getFileKey());
        FlashingResourceUtil.handleBootloader(info, bootloader, flashingResourcesParser);
        keyAndFiles.remove(BuildInfoKey.BuildInfoFileKey.BOOTLOADER_IMAGE.getFileKey());
        File baseband = keyAndFiles.get(BuildInfoKey.BuildInfoFileKey.BASEBAND_IMAGE.getFileKey());
        FlashingResourceUtil.handleBaseband(info, baseband, flashingResourcesParser);
        keyAndFiles.remove(BuildInfoKey.BuildInfoFileKey.BASEBAND_IMAGE.getFileKey());
        if (info instanceof IDeviceBuildInfo && deviceImageFlavor != null) {
            ((IDeviceBuildInfo)info).setDeviceBuildFlavor(deviceImageFlavor);
        }
        return true;
    }

    private static void handleBaseband(IBuildInfo info, File baseband, IFlashingResourcesParser flashingResourcesParser) {
        if (baseband == null) {
            return;
        }
        String buildId = flashingResourcesParser.getRequiredBasebandVersion();
        info.setFile(BuildInfoKey.BuildInfoFileKey.BASEBAND_IMAGE, baseband, buildId);
        if (CurrentInvocation.getInvocationFiles() != null) {
            CurrentInvocation.getInvocationFiles().put(BuildInfoKey.BuildInfoFileKey.BASEBAND_IMAGE.getFileKey(), baseband);
        }
    }

    private static void handleBootloader(IBuildInfo info, File bootloader, IFlashingResourcesParser flashingResourcesParser) {
        if (bootloader == null) {
            return;
        }
        String buildId = flashingResourcesParser.getRequiredBootloaderVersion();
        LogUtil.CLog.d("Bootloader from file: %s with version: %s", bootloader, buildId);
        info.setFile(BuildInfoKey.BuildInfoFileKey.BOOTLOADER_IMAGE, bootloader, buildId);
        if (CurrentInvocation.getInvocationFiles() != null) {
            CurrentInvocation.getInvocationFiles().put(BuildInfoKey.BuildInfoFileKey.BOOTLOADER_IMAGE.getFileKey(), bootloader);
        }
    }
}

