/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.io.File;

public class FuseUtil {
    static final long FUSE_ZIP_TIMEOUT_MILLIS = 300000L;
    private static Boolean sCanMountZip;

    static void resetCanMountZip() {
        sCanMountZip = null;
    }

    IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    public boolean canMountZip() {
        if (sCanMountZip == null) {
            CommandResult res = this.getRunUtil().runTimedCmd(300000L, "test", "-c", "/dev/fuse");
            CommandResult res2 = this.getRunUtil().runTimedCmd(300000L, "which", "fuse-zip");
            sCanMountZip = res.getStatus().equals((Object)CommandStatus.SUCCESS) && res2.getStatus().equals((Object)CommandStatus.SUCCESS) && !res2.getStdout().isEmpty();
        }
        return sCanMountZip;
    }

    public void mountZip(File zipFile, File mountDir) {
        CommandResult res = this.getRunUtil().runTimedCmd(300000L, "fuse-zip", "-r", zipFile.getAbsolutePath(), mountDir.getAbsolutePath());
        if (!res.getStatus().equals((Object)CommandStatus.SUCCESS)) {
            throw new HarnessRuntimeException(String.format("Failed to mount %s: %s", zipFile, res.getStderr()), InfraErrorIdentifier.LAB_HOST_FILESYSTEM_ERROR);
        }
    }

    public void unmountZip(File mountDir) {
        CommandResult res = this.getRunUtil().runTimedCmd(300000L, "fusermount", "-u", mountDir.getAbsolutePath());
        if (!res.getStatus().equals((Object)CommandStatus.SUCCESS)) {
            LogUtil.CLog.w("Failed to unmount %s: %s", mountDir, res.getStderr());
        }
    }
}

