/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Deprecated
public class GCSBucketUtil {
    private static final String CMD_COPY = "cp";
    private static final String CMD_MAKE_BUCKET = "mb";
    private static final String CMD_LS = "ls";
    private static final String CMD_STAT = "stat";
    private static final String CMD_HASH = "hash";
    private static final String CMD_REMOVE = "rm";
    private static final String CMD_REMOVE_BUCKET = "rb";
    private static final String CMD_VERSION = "-v";
    private static final String ENV_BOTO_PATH = "BOTO_PATH";
    private static final String ENV_BOTO_CONFIG = "BOTO_CONFIG";
    private static final String FILENAME_STDOUT = "-";
    private static final String FLAG_FORCE = "-f";
    private static final String FLAG_NO_CLOBBER = "-n";
    private static final String FLAG_PARALLEL = "-m";
    private static final String FLAG_PROJECT_ID = "-p";
    private static final String FLAG_RECURSIVE = "-r";
    private static final String GCS_SCHEME = "gs";
    private static final String GSUTIL = "gsutil";
    private static boolean mCheckedGsutil = false;
    private int mAttempts = 1;
    private String mBotoPath = null;
    private String mBotoConfig = null;
    private String mBucketName = null;
    private boolean mNoClobber = false;
    private boolean mParallel = false;
    private boolean mRecursive = true;
    private long mRetryInterval = 0L;
    private long mTimeoutMs = 0L;

    public GCSBucketUtil(String bucketName) {
        this.setBucketName(bucketName);
    }

    void checkGSUtil() throws IOException {
        if (mCheckedGsutil) {
            return;
        }
        CommandResult res = this.getRunUtil().runTimedCmd(this.mTimeoutMs, GSUTIL, CMD_VERSION);
        if (!CommandStatus.SUCCESS.equals((Object)res.getStatus())) {
            throw new IOException("gsutil is not installed.\nhttps://cloud.google.com/storage/docs/gsutil for instructions.");
        }
        mCheckedGsutil = true;
    }

    public CommandResult copy(String source, String dest) throws IOException {
        this.checkGSUtil();
        LogUtil.CLog.d("Copying %s => %s", source, dest);
        IRunUtil run = this.getRunUtil();
        ArrayList<String> command = new ArrayList<String>();
        command.add(GSUTIL);
        if (this.mParallel) {
            command.add(FLAG_PARALLEL);
        }
        command.add(CMD_COPY);
        if (this.mRecursive) {
            command.add(FLAG_RECURSIVE);
        }
        if (this.mNoClobber) {
            command.add(FLAG_NO_CLOBBER);
        }
        command.add(source);
        command.add(dest);
        String[] commandAsStr = command.toArray(new String[0]);
        CommandResult res = run.runTimedCmdRetry(this.mTimeoutMs, this.mRetryInterval, this.mAttempts, commandAsStr);
        if (!CommandStatus.SUCCESS.equals((Object)res.getStatus())) {
            throw new IOException(String.format("Failed to copy '%s' -> '%s' with %s\nstdout: %s\nstderr: %s", new Object[]{source, dest, res.getStatus(), res.getStdout(), res.getStderr()}));
        }
        return res;
    }

    public int getAttempts() {
        return this.mAttempts;
    }

    public String getBotoConfig() {
        return this.mBotoConfig;
    }

    public String getBotoPath() {
        return this.mBotoPath;
    }

    public String getBucketName() {
        return this.mBucketName;
    }

    public boolean getNoClobber() {
        return this.mNoClobber;
    }

    public boolean getParallel() {
        return this.mParallel;
    }

    public boolean getRecursive() {
        return this.mRecursive;
    }

    public long getRetryInterval() {
        return this.mRetryInterval;
    }

    protected IRunUtil getRunUtil() {
        RunUtil run = new RunUtil();
        if (this.mBotoPath != null) {
            run.setEnvVariable(ENV_BOTO_PATH, this.mBotoPath);
        }
        if (this.mBotoConfig != null) {
            run.setEnvVariable(ENV_BOTO_CONFIG, this.mBotoConfig);
        }
        return run;
    }

    public long getTimeout() {
        return this.mTimeoutMs;
    }

    String getUriForGcsPath(Path path) {
        if (!path.isAbsolute()) {
            path = Paths.get("/", new String[0]).resolve(path);
        }
        return String.format("%s://%s%s", GCS_SCHEME, this.mBucketName, path.toString());
    }

    public CommandResult makeBucket(String projectId) throws IOException {
        this.checkGSUtil();
        LogUtil.CLog.d("Making bucket %s for project %s", this.mBucketName, projectId);
        ArrayList<String> command = new ArrayList<String>();
        command.add(GSUTIL);
        command.add(CMD_MAKE_BUCKET);
        if (projectId != null) {
            command.add(FLAG_PROJECT_ID);
            command.add(projectId);
        }
        command.add(this.getUriForGcsPath(Paths.get("/", new String[0])));
        CommandResult res = this.getRunUtil().runTimedCmdRetry(this.mTimeoutMs, this.mRetryInterval, this.mAttempts, command.toArray(new String[0]));
        if (!CommandStatus.SUCCESS.equals((Object)res.getStatus())) {
            throw new IOException(String.format("Failed to create bucket '%s' with %s\nstdout: %s\nstderr: %s", new Object[]{this.mBucketName, res.getStatus(), res.getStdout(), res.getStderr()}));
        }
        return res;
    }

    public List<String> ls(Path bucketPath) throws IOException {
        this.checkGSUtil();
        LogUtil.CLog.d("Check stat of %s %s", this.mBucketName, bucketPath);
        ArrayList<String> command = new ArrayList<String>();
        command.add(GSUTIL);
        command.add(CMD_LS);
        command.add(this.getUriForGcsPath(bucketPath));
        CommandResult res = this.getRunUtil().runTimedCmdRetry(this.mTimeoutMs, this.mRetryInterval, this.mAttempts, command.toArray(new String[0]));
        if (!CommandStatus.SUCCESS.equals((Object)res.getStatus())) {
            throw new IOException(String.format("Failed to list path '%s %s' with %s\nstdout: %s\nstderr: %s", new Object[]{this.mBucketName, bucketPath, res.getStatus(), res.getStdout(), res.getStderr()}));
        }
        return Arrays.asList(res.getStdout().split("\n"));
    }

    public boolean isFile(String path) throws IOException {
        if (path.endsWith("/")) {
            return false;
        }
        List<String> files = this.ls(Paths.get(path, new String[0]));
        if (files.size() > 1) {
            return false;
        }
        if (files.size() == 1) {
            return files.get(0).equals(this.getUriForGcsPath(Paths.get(path, new String[0])));
        }
        return false;
    }

    public GCSFileMetadata stat(Path bucketPath) throws IOException {
        this.checkGSUtil();
        LogUtil.CLog.d("Check stat of %s %s", this.mBucketName, bucketPath);
        ArrayList<String> command = new ArrayList<String>();
        command.add(GSUTIL);
        command.add(CMD_STAT);
        command.add(this.getUriForGcsPath(bucketPath));
        CommandResult res = this.getRunUtil().runTimedCmdRetry(this.mTimeoutMs, this.mRetryInterval, this.mAttempts, command.toArray(new String[0]));
        if (!CommandStatus.SUCCESS.equals((Object)res.getStatus())) {
            throw new IOException(String.format("Failed to stat path '%s %s' with %s\nstdout: %s\nstderr: %s", new Object[]{this.mBucketName, bucketPath, res.getStatus(), res.getStdout(), res.getStderr()}));
        }
        return GCSFileMetadata.parseStat(res.getStdout());
    }

    public String md5Hash(File localFile) throws IOException {
        Pattern md5Pattern;
        Matcher matcher;
        this.checkGSUtil();
        ArrayList<String> command = new ArrayList<String>();
        command.add(GSUTIL);
        command.add(CMD_HASH);
        command.add(FLAG_PARALLEL);
        command.add(localFile.getAbsolutePath());
        CommandResult res = this.getRunUtil().runTimedCmdRetry(this.mTimeoutMs, this.mRetryInterval, this.mAttempts, command.toArray(new String[0]));
        if (CommandStatus.SUCCESS.equals((Object)res.getStatus()) && (matcher = (md5Pattern = Pattern.compile(".*Hash\\s*\\(md5\\)\\:\\s*(.*?)\n.*", 40)).matcher(res.getStdout())).find()) {
            return matcher.group(1);
        }
        throw new IOException(String.format("Failed to calculate md5 hash for '%s' with %s\nstdout: %s\nstderr: %s", new Object[]{localFile.getAbsoluteFile(), res.getStatus(), res.getStdout(), res.getStderr()}));
    }

    public CommandResult pull(Path bucketPath) throws IOException {
        return this.copy(this.getUriForGcsPath(bucketPath), ".");
    }

    public CommandResult pull(Path bucketPath, File localFile) throws IOException {
        return this.copy(this.getUriForGcsPath(bucketPath), localFile.getPath());
    }

    public String pullContents(Path bucketPath) throws IOException {
        CommandResult res = this.copy(this.getUriForGcsPath(bucketPath), FILENAME_STDOUT);
        return res.getStdout();
    }

    public CommandResult push(File localFile) throws IOException {
        return this.push(localFile, Paths.get("/", new String[0]));
    }

    public CommandResult push(File localFile, Path bucketPath) throws IOException {
        return this.copy(localFile.getAbsolutePath(), this.getUriForGcsPath(bucketPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandResult pushString(String contents, Path bucketPath) throws IOException {
        CommandResult commandResult;
        File localFile = null;
        try {
            localFile = FileUtil.createTempFile(this.mBucketName, null);
            FileUtil.writeToFile(contents, localFile);
            commandResult = this.copy(localFile.getAbsolutePath(), this.getUriForGcsPath(bucketPath));
        }
        catch (Throwable throwable) {
            FileUtil.deleteFile(localFile);
            throw throwable;
        }
        FileUtil.deleteFile(localFile);
        return commandResult;
    }

    public CommandResult remove(String pattern, boolean force) throws IOException {
        this.checkGSUtil();
        String path = this.getUriForGcsPath(Paths.get(pattern, new String[0]));
        LogUtil.CLog.d("Removing file(s) %s", path);
        ArrayList<String> command = new ArrayList<String>();
        command.add(GSUTIL);
        command.add(CMD_REMOVE);
        if (this.mRecursive) {
            command.add(FLAG_RECURSIVE);
        }
        if (force) {
            command.add(FLAG_FORCE);
        }
        command.add(path);
        CommandResult res = this.getRunUtil().runTimedCmdRetry(this.mTimeoutMs, this.mRetryInterval, this.mAttempts, command.toArray(new String[0]));
        if (!force && !CommandStatus.SUCCESS.equals((Object)res.getStatus())) {
            throw new IOException(String.format("Failed to remove '%s' with %s\nstdout: %s\nstderr: %s", new Object[]{pattern, res.getStatus(), res.getStdout(), res.getStderr()}));
        }
        return res;
    }

    public CommandResult remove(String pattern) throws IOException {
        return this.remove(pattern, false);
    }

    public CommandResult remove(Path path, boolean force) throws IOException {
        return this.remove(path.toString(), force);
    }

    public CommandResult remove(Path path) throws IOException {
        return this.remove(path.toString(), false);
    }

    public CommandResult removeBucket() throws IOException {
        this.checkGSUtil();
        LogUtil.CLog.d("Removing bucket %s", this.mBucketName);
        String[] command = new String[]{GSUTIL, CMD_REMOVE_BUCKET, this.getUriForGcsPath(Paths.get("/", new String[0]))};
        CommandResult res = this.getRunUtil().runTimedCmdRetry(this.mTimeoutMs, this.mRetryInterval, this.mAttempts, command);
        if (!CommandStatus.SUCCESS.equals((Object)res.getStatus())) {
            throw new IOException(String.format("Failed to remove bucket '%s' with %s\nstdout: %s\nstderr: %s", new Object[]{this.mBucketName, res.getStatus(), res.getStdout(), res.getStderr()}));
        }
        return res;
    }

    public void setAttempts(int attempts) {
        this.mAttempts = attempts;
    }

    public void setBotoConfig(String botoConfig) {
        this.mBotoConfig = botoConfig;
    }

    public void setBotoPath(String botoPath) {
        this.mBotoPath = botoPath;
    }

    public void setBucketName(String bucketName) {
        this.mBucketName = bucketName;
    }

    public void setNoClobber(boolean noClobber) {
        this.mNoClobber = noClobber;
    }

    public void setParallel(boolean parallel) {
        this.mParallel = parallel;
    }

    public void setRecursive(boolean recursive) {
        this.mRecursive = recursive;
    }

    public void setRetryInterval(long retryInterval) {
        this.mRetryInterval = retryInterval;
    }

    public void setTimeoutMs(long timeout) {
        this.mTimeoutMs = timeout;
    }

    public void setTimeout(long timeout, TimeUnit unit) {
        this.setTimeoutMs(unit.toMillis(timeout));
    }

    public static class GCSFileMetadata {
        public String mName;
        public String mMd5Hash = null;

        private GCSFileMetadata() {
        }

        public static GCSFileMetadata parseStat(String statOutput) {
            GCSFileMetadata info = new GCSFileMetadata();
            String[] infoLines = statOutput.split("\n");
            info.mName = infoLines[0].substring(0, infoLines[0].length() - 1);
            for (String line : infoLines) {
                String[] keyValue = line.split(":", 2);
                String key = keyValue[0].trim();
                String value = keyValue[1].trim();
                if (!"Hash (md5)".equals(key)) continue;
                info.mMd5Hash = value;
            }
            return info;
        }
    }
}

