/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.util.GoogleApiClientUtil;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.storage.Storage;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;

public abstract class GCSCommon {
    private static final String GCS_JSON_KEY = "gcs-json-key";
    protected static final int DEFAULT_TIMEOUT = 600000;
    private File mJsonKeyFile = null;
    private Storage mStorage;

    public GCSCommon(File jsonKeyFile) {
        this.mJsonKeyFile = jsonKeyFile;
    }

    public GCSCommon() {
    }

    void setJsonKeyFile(File jsonKeyFile) {
        this.mJsonKeyFile = jsonKeyFile;
    }

    protected Storage getStorage(Collection<String> scopes) throws IOException {
        Credential credential = null;
        try {
            if (this.mStorage == null) {
                credential = GoogleApiClientUtil.createCredential(scopes, true, this.mJsonKeyFile, GCS_JSON_KEY, new File[0]);
                this.mStorage = new Storage.Builder(GoogleNetHttpTransport.newTrustedTransport(), GsonFactory.getDefaultInstance(), GoogleApiClientUtil.configureRetryStrategy(GoogleApiClientUtil.setHttpTimeout(credential, 600000, 600000))).setApplicationName("tradefed").build();
            }
            return this.mStorage;
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }
}

