/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.IFileDownloader;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.GCSCommon;
import com.android.tradefed.util.StreamUtil;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Objects;
import com.google.api.services.storage.model.StorageObject;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GCSFileDownloader
extends GCSCommon
implements IFileDownloader {
    public static final String GCS_PREFIX = "gs://";
    public static final String GCS_APPROX_PREFIX = "gs:/";
    private static final Pattern GCS_PATH_PATTERN = Pattern.compile("gs://([^/]*)/(.*)");
    private static final String PATH_SEP = "/";
    private static final Collection<String> SCOPES = Collections.singleton("https://www.googleapis.com/auth/devstorage.read_only");
    private static final long LIST_BATCH_SIZE = 100L;
    private Boolean mCreateEmptyFile = false;
    private final LoadingCache<String, Boolean> mFreshnessCache;

    public GCSFileDownloader(File jsonKeyFile) {
        this(false);
        this.setJsonKeyFile(jsonKeyFile);
    }

    public GCSFileDownloader(Boolean createEmptyFile) {
        this.mCreateEmptyFile = createEmptyFile;
        this.mFreshnessCache = CacheBuilder.newBuilder().maximumSize(50L).expireAfterAccess(60L, TimeUnit.MINUTES).build(new CacheLoader<String, Boolean>(){

            @Override
            public Boolean load(String key) throws BuildRetrievalError {
                return true;
            }
        });
    }

    public GCSFileDownloader() {
        this(false);
    }

    protected void clearCache() {
        this.mFreshnessCache.invalidateAll();
    }

    private Storage getStorage() throws IOException {
        return this.getStorage(SCOPES);
    }

    @VisibleForTesting
    StorageObject getRemoteFileMetaData(String bucketName, String remoteFilename) throws IOException {
        int i = 0;
        while (true) {
            ++i;
            try {
                return (StorageObject)this.getStorage().objects().get(bucketName, remoteFilename).execute();
            }
            catch (GoogleJsonResponseException e) {
                if (e.getStatusCode() == 404) {
                    return null;
                }
                throw e;
            }
            catch (SocketTimeoutException e) {
                if (i < 2) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public File downloadFile(String remoteFilePath) throws BuildRetrievalError {
        File destFile = this.createTempFile(remoteFilePath, null);
        try {
            this.downloadFile(remoteFilePath, destFile);
            return destFile;
        }
        catch (BuildRetrievalError e) {
            FileUtil.recursiveDelete(destFile);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream downloadFile(String bucketName, String filename) throws IOException {
        ByteArrayInputStream byteArrayInputStream;
        InputStream remoteInput = null;
        ByteArrayOutputStream tmpStream = null;
        try {
            remoteInput = this.getStorage().objects().get(bucketName, filename).executeMediaAsInputStream();
            tmpStream = new ByteArrayOutputStream();
            StreamUtil.copyStreams(remoteInput, tmpStream);
            byteArrayInputStream = new ByteArrayInputStream(tmpStream.toByteArray());
        }
        catch (Throwable throwable) {
            StreamUtil.close(remoteInput);
            StreamUtil.close(tmpStream);
            throw throwable;
        }
        StreamUtil.close(remoteInput);
        StreamUtil.close(tmpStream);
        return byteArrayInputStream;
    }

    @Override
    public void downloadFile(String remotePath, File destFile) throws BuildRetrievalError {
        String[] pathParts = this.parseGcsPath(remotePath);
        this.downloadFile(pathParts[0], pathParts[1], destFile);
    }

    @VisibleForTesting
    void downloadFile(String bucketName, String remoteFilename, File localFile) throws BuildRetrievalError {
        int i = 0;
        try {
            while (true) {
                ++i;
                try {
                    if (!this.isRemoteFolder(bucketName, remoteFilename)) {
                        this.fetchRemoteFile(bucketName, remoteFilename, localFile);
                        return;
                    }
                    remoteFilename = this.sanitizeDirectoryName(remoteFilename);
                    this.recursiveDownloadFolder(bucketName, remoteFilename, localFile);
                    return;
                }
                catch (SocketException se) {
                    if (i >= 2) {
                        throw se;
                    }
                    LogUtil.CLog.e("Error '%s' while downloading gs://%s/%s. retrying.", se.getMessage(), bucketName, remoteFilename);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            String message2 = String.format("Failed to download gs://%s/%s due to: %s", bucketName, remoteFilename, e.getMessage());
            LogUtil.CLog.e(message2);
            throw new BuildRetrievalError(message2, (Throwable)e, InfraErrorIdentifier.GCS_ERROR);
        }
    }

    private boolean isFileFresh(File localFile, StorageObject remoteFile) {
        if (localFile == null && remoteFile == null) {
            return true;
        }
        if (localFile == null || remoteFile == null) {
            return false;
        }
        if (!localFile.exists()) {
            return false;
        }
        return remoteFile.getMd5Hash().equals(FileUtil.calculateBase64Md5(localFile));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isFresh(File localFile, String remotePath) throws BuildRetrievalError {
        Boolean cache;
        String[] pathParts = this.parseGcsPath(remotePath);
        String bucketName = pathParts[0];
        String remoteFilename = pathParts[1];
        if (localFile != null && localFile.exists() && (cache = (Boolean)this.mFreshnessCache.getIfPresent(remotePath)) != null && Boolean.TRUE.equals(cache)) {
            return true;
        }
        try (CloseableTraceScope ignored = new CloseableTraceScope("gcs_is_fresh " + remotePath);){
            StorageObject remoteFileMeta = this.getRemoteFileMetaData(bucketName, remoteFilename);
            if (localFile == null || !localFile.exists()) {
                if (!this.isRemoteFolder(bucketName, remoteFilename) && remoteFileMeta == null) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            if (!localFile.isDirectory()) {
                boolean bl = this.isFileFresh(localFile, remoteFileMeta);
                return bl;
            }
            remoteFilename = this.sanitizeDirectoryName(remoteFilename);
            boolean fresh = this.recursiveCheckFolderFreshness(bucketName, remoteFilename, localFile);
            this.mFreshnessCache.put(remotePath, fresh);
            boolean bl = fresh;
            return bl;
        }
        catch (IOException e) {
            this.mFreshnessCache.invalidate(remotePath);
            throw new BuildRetrievalError(e.getMessage(), (Throwable)e, InfraErrorIdentifier.GCS_ERROR);
        }
    }

    private boolean recursiveCheckFolderFreshness(String bucketName, String remoteFolderName, File localFolder) throws IOException {
        HashSet<String> subFilenames = new HashSet<String>(Arrays.asList(localFolder.list()));
        ArrayList<String> subRemoteFolders = new ArrayList<String>();
        ArrayList<StorageObject> subRemoteFiles = new ArrayList<StorageObject>();
        this.listRemoteFilesUnderFolder(bucketName, remoteFolderName, subRemoteFiles, subRemoteFolders);
        for (StorageObject subRemoteFile : subRemoteFiles) {
            String subFilename = Paths.get(subRemoteFile.getName(), new String[0]).getFileName().toString();
            if (!this.isFileFresh(new File(localFolder, subFilename), subRemoteFile)) {
                return false;
            }
            subFilenames.remove(subFilename);
        }
        for (String subRemoteFolder : subRemoteFolders) {
            String subFolderName = Paths.get(subRemoteFolder, new String[0]).getFileName().toString();
            File subFolder = new File(localFolder, subFolderName);
            if (!subFolder.exists()) {
                return false;
            }
            if (!subFolder.isDirectory()) {
                LogUtil.CLog.w("%s exists as a non-directory.", subFolder);
                subFolder = new File(localFolder, subFolderName + "_folder");
            }
            if (!this.recursiveCheckFolderFreshness(bucketName, subRemoteFolder, subFolder)) {
                return false;
            }
            subFilenames.remove(subFolder.getName());
        }
        return subFilenames.isEmpty();
    }

    void listRemoteFilesUnderFolder(String bucketName, String folder, List<StorageObject> subFiles, List<String> subFolders) throws IOException {
        Objects objects;
        String pageToken = null;
        do {
            Storage.Objects.List listOperation = this.getStorage().objects().list(bucketName).setPrefix(folder).setDelimiter(PATH_SEP).setMaxResults(100L);
            if (pageToken != null) {
                listOperation.setPageToken(pageToken);
            }
            if ((objects = (Objects)listOperation.execute()).getItems() != null && !objects.getItems().isEmpty()) {
                for (int i = 0; i < objects.getItems().size(); ++i) {
                    if (objects.getItems().get(i).getName().equals(folder)) continue;
                    subFiles.add(objects.getItems().get(i));
                }
            }
            if (objects.getPrefixes() == null || objects.getPrefixes().isEmpty()) continue;
            subFolders.addAll(objects.getPrefixes());
        } while ((pageToken = objects.getNextPageToken()) != null);
    }

    String[] parseGcsPath(String remotePath) throws BuildRetrievalError {
        Matcher m;
        if (remotePath.startsWith(GCS_APPROX_PREFIX) && !remotePath.startsWith(GCS_PREFIX)) {
            remotePath = remotePath.replaceAll(GCS_APPROX_PREFIX, GCS_PREFIX);
        }
        if (!(m = GCS_PATH_PATTERN.matcher(remotePath)).find()) {
            throw new BuildRetrievalError(String.format("Only GCS path is supported, %s is not supported", remotePath), (ErrorIdentifier)InfraErrorIdentifier.ARTIFACT_UNSUPPORTED_PATH);
        }
        return new String[]{m.group(1), m.group(2)};
    }

    String sanitizeDirectoryName(String name) {
        if (!name.endsWith(PATH_SEP)) {
            name = name + PATH_SEP;
        }
        return name;
    }

    @VisibleForTesting
    boolean isRemoteFolder(String bucketName, String filename) throws IOException {
        filename = this.sanitizeDirectoryName(filename);
        Objects objects = (Objects)this.getStorage().objects().list(bucketName).setPrefix(filename).setDelimiter(PATH_SEP).setMaxResults(1L).execute();
        if (objects.getItems() != null && !objects.getItems().isEmpty()) {
            return true;
        }
        return objects.getPrefixes() != null && !objects.getPrefixes().isEmpty();
    }

    private void fetchRemoteFile(String bucketName, String remoteFilename, File localFile) throws IOException, BuildRetrievalError {
        LogUtil.CLog.d("Fetching gs://%s/%s to %s.", bucketName, remoteFilename, localFile.toString());
        StorageObject meta = this.getRemoteFileMetaData(bucketName, remoteFilename);
        if (meta == null || meta.getSize().equals(BigInteger.ZERO)) {
            if (!this.mCreateEmptyFile.booleanValue()) {
                throw new BuildRetrievalError(String.format("File (not folder) gs://%s/%s doesn't exist or is size 0.", bucketName, remoteFilename), (ErrorIdentifier)InfraErrorIdentifier.GCS_ERROR);
            }
            LogUtil.CLog.d("GCS file is empty: gs://%s/%s", bucketName, remoteFilename);
            localFile.createNewFile();
            return;
        }
        try (FileOutputStream writeStream = new FileOutputStream(localFile);){
            this.getStorage().objects().get(bucketName, remoteFilename).executeMediaAndDownloadTo(writeStream);
        }
    }

    private void recursiveDownloadFolder(String bucketName, String remoteFolderName, File localFolder) throws IOException, BuildRetrievalError {
        LogUtil.CLog.d("Downloading folder gs://%s/%s.", bucketName, remoteFolderName);
        if (!localFolder.exists()) {
            FileUtil.mkdirsRWX(localFolder);
        }
        if (!localFolder.isDirectory()) {
            String error = String.format("%s is not a folder. (gs://%s/%s)", localFolder, bucketName, remoteFolderName);
            LogUtil.CLog.e(error);
            throw new IOException(error);
        }
        HashSet<String> subFilenames = new HashSet<String>(Arrays.asList(localFolder.list()));
        ArrayList<String> subRemoteFolders = new ArrayList<String>();
        ArrayList<StorageObject> subRemoteFiles = new ArrayList<StorageObject>();
        this.listRemoteFilesUnderFolder(bucketName, remoteFolderName, subRemoteFiles, subRemoteFolders);
        for (StorageObject subRemoteFile : subRemoteFiles) {
            String subFilename = Paths.get(subRemoteFile.getName(), new String[0]).getFileName().toString();
            this.fetchRemoteFile(bucketName, subRemoteFile.getName(), new File(localFolder, subFilename));
            subFilenames.remove(subFilename);
        }
        for (String subRemoteFolder : subRemoteFolders) {
            String subFolderName = Paths.get(subRemoteFolder, new String[0]).getFileName().toString();
            File subFolder = new File(localFolder, subFolderName);
            if (new File(localFolder, subFolderName).exists() && !new File(localFolder, subFolderName).isDirectory()) {
                LogUtil.CLog.w("%s exists as a non-directory.", subFolder);
                subFolder = new File(localFolder, subFolderName + "_folder");
            }
            this.recursiveDownloadFolder(bucketName, subRemoteFolder, subFolder);
            subFilenames.remove(subFolder.getName());
        }
        for (String subFilename : subFilenames) {
            FileUtil.recursiveDelete(new File(localFolder, subFilename));
        }
    }

    @VisibleForTesting
    File createTempFile(String remoteFilePath, File rootDir) throws BuildRetrievalError {
        return GCSFileDownloader.createTempFileForRemote(remoteFilePath, rootDir);
    }

    public static File createTempFileForRemote(String remoteFilePath, File rootDir) throws BuildRetrievalError {
        try {
            File tmpFile = FileUtil.createTempFileForRemote(remoteFilePath, rootDir);
            tmpFile.delete();
            return tmpFile;
        }
        catch (IOException e) {
            String msg = String.format("Failed to create tmp file for %s", remoteFilePath);
            throw new BuildRetrievalError(msg, e);
        }
    }
}

